@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.insights.kotlin.outputs.WorkbookResourceResponseIdentity
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.WorkbookResourceResponseIdentity.Companion.toKotlin as workbookResourceResponseIdentityToKotlin

/**
 * Builder for [Workbook].
 */
@PulumiTagMarker
public class WorkbookResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkbookArgs = WorkbookArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkbookArgsBuilder.() -> Unit) {
        val builder = WorkbookArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Workbook {
        val builtJavaResource = com.pulumi.azurenative.insights.Workbook(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Workbook(builtJavaResource)
    }
}

/**
 * A workbook definition.
 * Azure REST API version: 2022-04-01. Prior API version in Azure Native 1.x: 2020-10-20.
 * Other available API versions: 2015-05-01, 2021-03-08, 2021-08-01, 2023-06-01.
 * ## Example Usage
 * ### WorkbookAdd
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workbook = new AzureNative.Insights.Workbook("workbook", new()
 *     {
 *         Category = "workbook",
 *         Description = "Sample workbook",
 *         DisplayName = "Sample workbook",
 *         Kind = "shared",
 *         Location = "westus",
 *         ResourceGroupName = "my-resource-group",
 *         ResourceName = "deadb33f-5e0d-4064-8ebb-1a4ed0313eb2",
 *         SerializedData = "{\"version\":\"Notebook/1.0\",\"items\":[{\"type\":1,\"content\":\"{\"json\":\"## New workbook\\r\\n---\\r\\n\\r\\nWelcome to your new workbook.  This area will display text formatted as markdown.\\r\\n\\r\\n\\r\\nWe've included a basic analytics query to get you started. Use the `Edit` button below each section to configure it or add more sections.\"}\",\"halfWidth\":null,\"conditionalVisibility\":null},{\"type\":3,\"content\":\"{\"version\":\"KqlItem/1.0\",\"query\":\"union withsource=TableName *\\n| summarize Count=count() by TableName\\n| render barchart\",\"showQuery\":false,\"size\":1,\"aggregation\":0,\"showAnnotations\":false}\",\"halfWidth\":null,\"conditionalVisibility\":null}],\"isLocked\":false}",
 *         SourceId = "/subscriptions/6b643656-33eb-422f-aee8-3ac145d124af/resourcegroups/my-resource-group",
 *         Tags =
 *         {
 *             { "TagSample01", "sample01" },
 *             { "TagSample02", "sample02" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewWorkbook(ctx, "workbook", &insights.WorkbookArgs{
 * 			Category:          pulumi.String("workbook"),
 * 			Description:       pulumi.String("Sample workbook"),
 * 			DisplayName:       pulumi.String("Sample workbook"),
 * 			Kind:              pulumi.String("shared"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ResourceName:      pulumi.String("deadb33f-5e0d-4064-8ebb-1a4ed0313eb2"),
 * 			SerializedData:    pulumi.String("{\"version\":\"Notebook/1.0\",\"items\":[{\"type\":1,\"content\":\"{\"json\":\"## New workbook\\r\\n---\\r\\n\\r\\nWelcome to your new workbook.  This area will display text formatted as markdown.\\r\\n\\r\\n\\r\\nWe've included a basic analytics query to get you started. Use the `Edit` button below each section to configure it or add more sections.\"}\",\"halfWidth\":null,\"conditionalVisibility\":null},{\"type\":3,\"content\":\"{\"version\":\"KqlItem/1.0\",\"query\":\"union withsource=TableName *\\n| summarize Count=count() by TableName\\n| render barchart\",\"showQuery\":false,\"size\":1,\"aggregation\":0,\"showAnnotations\":false}\",\"halfWidth\":null,\"conditionalVisibility\":null}],\"isLocked\":false}"),
 * 			SourceId:          pulumi.String("/subscriptions/6b643656-33eb-422f-aee8-3ac145d124af/resourcegroups/my-resource-group"),
 * 			Tags: pulumi.StringMap{
 * 				"TagSample01": pulumi.String("sample01"),
 * 				"TagSample02": pulumi.String("sample02"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.Workbook;
 * import com.pulumi.azurenative.insights.WorkbookArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workbook = new Workbook("workbook", WorkbookArgs.builder()
 *             .category("workbook")
 *             .description("Sample workbook")
 *             .displayName("Sample workbook")
 *             .kind("shared")
 *             .location("westus")
 *             .resourceGroupName("my-resource-group")
 *             .resourceName("deadb33f-5e0d-4064-8ebb-1a4ed0313eb2")
 *             .serializedData("{\"version\":\"Notebook/1.0\",\"items\":[{\"type\":1,\"content\":\"{\"json\":\"## New workbook\\r\\n---\\r\\n\\r\\nWelcome to your new workbook.  This area will display text formatted as markdown.\\r\\n\\r\\n\\r\\nWe've included a basic analytics query to get you started. Use the `Edit` button below each section to configure it or add more sections.\"}\",\"halfWidth\":null,\"conditionalVisibility\":null},{\"type\":3,\"content\":\"{\"version\":\"KqlItem/1.0\",\"query\":\"union withsource=TableName *\\n| summarize Count=count() by TableName\\n| render barchart\",\"showQuery\":false,\"size\":1,\"aggregation\":0,\"showAnnotations\":false}\",\"halfWidth\":null,\"conditionalVisibility\":null}],\"isLocked\":false}")
 *             .sourceId("/subscriptions/6b643656-33eb-422f-aee8-3ac145d124af/resourcegroups/my-resource-group")
 *             .tags(Map.ofEntries(
 *                 Map.entry("TagSample01", "sample01"),
 *                 Map.entry("TagSample02", "sample02")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:Workbook deadb33f-5e0d-4064-8ebb-1a4ed0313eb2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/workbooks/{resourceName}
 * ```
 */
public class Workbook internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.Workbook,
) : KotlinCustomResource(javaResource, WorkbookMapper) {
    /**
     * Workbook category, as defined by the user at creation time.
     */
    public val category: Output<String>
        get() = javaResource.category().applyValue({ args0 -> args0 })

    /**
     * The description of the workbook.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The user-defined name (display name) of the workbook.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Resource etag
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Identity used for BYOS
     */
    public val identity: Output<WorkbookResourceResponseIdentity>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    workbookResourceResponseIdentityToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The kind of workbook. Only valid value is shared.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The unique revision id for this workbook definition
     */
    public val revision: Output<String>
        get() = javaResource.revision().applyValue({ args0 -> args0 })

    /**
     * Configuration of this particular workbook. Configuration data is a string containing valid JSON
     */
    public val serializedData: Output<String>
        get() = javaResource.serializedData().applyValue({ args0 -> args0 })

    /**
     * ResourceId for a source resource.
     */
    public val sourceId: Output<String>?
        get() = javaResource.sourceId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resourceId to the storage account when bring your own storage is used
     */
    public val storageUri: Output<String>?
        get() = javaResource.storageUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Date and time in UTC of the last modification that was made to this workbook definition.
     */
    public val timeModified: Output<String>
        get() = javaResource.timeModified().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Unique user id of the specific user that owns this workbook.
     */
    public val userId: Output<String>
        get() = javaResource.userId().applyValue({ args0 -> args0 })

    /**
     * Workbook schema version format, like 'Notebook/1.0', which should match the workbook in serializedData
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object WorkbookMapper : ResourceMapper<Workbook> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.Workbook::class == javaResource::class

    override fun map(javaResource: Resource): Workbook = Workbook(
        javaResource as
            com.pulumi.azurenative.insights.Workbook,
    )
}

/**
 * @see [Workbook].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Workbook].
 */
public suspend fun workbook(name: String, block: suspend WorkbookResourceBuilder.() -> Unit):
    Workbook {
    val builder = WorkbookResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Workbook].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workbook(name: String): Workbook {
    val builder = WorkbookResourceBuilder()
    builder.name(name)
    return builder.build()
}
