@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the default access mode of queries through associated private endpoints in scope. If not specified default value is 'Open'. You can override this default setting for a specific private endpoint connection by adding an exclusion in the 'exclusions' array.
 */
public enum class AccessMode(
    public val javaValue: com.pulumi.azurenative.insights.enums.AccessMode,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.AccessMode> {
    Open(com.pulumi.azurenative.insights.enums.AccessMode.Open),
    PrivateOnly(com.pulumi.azurenative.insights.enums.AccessMode.PrivateOnly),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.AccessMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.AccessMode): AccessMode =
            AccessMode.values().first { it.javaValue == javaType }
    }
}
