@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * the operator that is used to compare the metric data and the threshold.
 */
public enum class ComparisonOperationType(
    public val javaValue: com.pulumi.azurenative.insights.enums.ComparisonOperationType,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.ComparisonOperationType> {
    Equals(com.pulumi.azurenative.insights.enums.ComparisonOperationType.Equals),
    NotEquals(com.pulumi.azurenative.insights.enums.ComparisonOperationType.NotEquals),
    GreaterThan(com.pulumi.azurenative.insights.enums.ComparisonOperationType.GreaterThan),
    GreaterThanOrEqual(com.pulumi.azurenative.insights.enums.ComparisonOperationType.GreaterThanOrEqual),
    LessThan(com.pulumi.azurenative.insights.enums.ComparisonOperationType.LessThan),
    LessThanOrEqual(com.pulumi.azurenative.insights.enums.ComparisonOperationType.LessThanOrEqual),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.ComparisonOperationType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.ComparisonOperationType):
            ComparisonOperationType =
            ComparisonOperationType.values().first { it.javaValue == javaType }
    }
}
