@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Describes what tool created this Application Insights component. Customers using this API should set this to the default 'rest'.
 */
public enum class RequestSource(
    public val javaValue: com.pulumi.azurenative.insights.enums.RequestSource,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.RequestSource> {
    Rest(com.pulumi.azurenative.insights.enums.RequestSource.Rest),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.RequestSource = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.RequestSource):
            RequestSource = RequestSource.values().first { it.javaValue == javaType }
    }
}
