@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * the scale direction. Whether the scaling action increases or decreases the number of instances.
 */
public enum class ScaleDirection(
    public val javaValue: com.pulumi.azurenative.insights.enums.ScaleDirection,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.ScaleDirection> {
    None(com.pulumi.azurenative.insights.enums.ScaleDirection.None),
    Increase(com.pulumi.azurenative.insights.enums.ScaleDirection.Increase),
    Decrease(com.pulumi.azurenative.insights.enums.ScaleDirection.Decrease),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.ScaleDirection = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.ScaleDirection):
            ScaleDirection = ScaleDirection.values().first { it.javaValue == javaType }
    }
}
