@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * the type of action that should occur when the scale rule fires.
 */
public enum class ScaleType(
    public val javaValue: com.pulumi.azurenative.insights.enums.ScaleType,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.ScaleType> {
    ChangeCount(com.pulumi.azurenative.insights.enums.ScaleType.ChangeCount),
    PercentChangeCount(com.pulumi.azurenative.insights.enums.ScaleType.PercentChangeCount),
    ExactCount(com.pulumi.azurenative.insights.enums.ScaleType.ExactCount),
    ServiceAllowedNextValue(com.pulumi.azurenative.insights.enums.ScaleType.ServiceAllowedNextValue),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.ScaleType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.ScaleType): ScaleType =
            ScaleType.values().first { it.javaValue == javaType }
    }
}
