@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Aggregation type. Relevant and required only for rules of the kind LogAlert.
 */
public enum class TimeAggregation(
    public val javaValue: com.pulumi.azurenative.insights.enums.TimeAggregation,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.TimeAggregation> {
    Count(com.pulumi.azurenative.insights.enums.TimeAggregation.Count),
    Average(com.pulumi.azurenative.insights.enums.TimeAggregation.Average),
    Minimum(com.pulumi.azurenative.insights.enums.TimeAggregation.Minimum),
    Maximum(com.pulumi.azurenative.insights.enums.TimeAggregation.Maximum),
    Total(com.pulumi.azurenative.insights.enums.TimeAggregation.Total),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.TimeAggregation = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.TimeAggregation):
            TimeAggregation = TimeAggregation.values().first { it.javaValue == javaType }
    }
}
