@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.AccessModeSettingsArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.AccessMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties that define the scope private link mode settings.
 * @property exclusions List of exclusions that override the default access mode settings for specific private endpoint connections.
 * @property ingestionAccessMode Specifies the default access mode of ingestion through associated private endpoints in scope. If not specified default value is 'Open'. You can override this default setting for a specific private endpoint connection by adding an exclusion in the 'exclusions' array.
 * @property queryAccessMode Specifies the default access mode of queries through associated private endpoints in scope. If not specified default value is 'Open'. You can override this default setting for a specific private endpoint connection by adding an exclusion in the 'exclusions' array.
 */
public data class AccessModeSettingsArgs(
    public val exclusions: Output<List<AccessModeSettingsExclusionArgs>>? = null,
    public val ingestionAccessMode: Output<Either<String, AccessMode>>,
    public val queryAccessMode: Output<Either<String, AccessMode>>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.AccessModeSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.AccessModeSettingsArgs =
        com.pulumi.azurenative.insights.inputs.AccessModeSettingsArgs.builder()
            .exclusions(
                exclusions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ingestionAccessMode(
                ingestionAccessMode.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .queryAccessMode(
                queryAccessMode.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [AccessModeSettingsArgs].
 */
@PulumiTagMarker
public class AccessModeSettingsArgsBuilder internal constructor() {
    private var exclusions: Output<List<AccessModeSettingsExclusionArgs>>? = null

    private var ingestionAccessMode: Output<Either<String, AccessMode>>? = null

    private var queryAccessMode: Output<Either<String, AccessMode>>? = null

    /**
     * @param value List of exclusions that override the default access mode settings for specific private endpoint connections.
     */
    @JvmName("qveokgldkenqbyyu")
    public suspend fun exclusions(`value`: Output<List<AccessModeSettingsExclusionArgs>>) {
        this.exclusions = value
    }

    @JvmName("phvspgafrqvuxefr")
    public suspend fun exclusions(vararg values: Output<AccessModeSettingsExclusionArgs>) {
        this.exclusions = Output.all(values.asList())
    }

    /**
     * @param values List of exclusions that override the default access mode settings for specific private endpoint connections.
     */
    @JvmName("toyoupyglnnabpli")
    public suspend fun exclusions(values: List<Output<AccessModeSettingsExclusionArgs>>) {
        this.exclusions = Output.all(values)
    }

    /**
     * @param value Specifies the default access mode of ingestion through associated private endpoints in scope. If not specified default value is 'Open'. You can override this default setting for a specific private endpoint connection by adding an exclusion in the 'exclusions' array.
     */
    @JvmName("wkcsuwayauvuebng")
    public suspend fun ingestionAccessMode(`value`: Output<Either<String, AccessMode>>) {
        this.ingestionAccessMode = value
    }

    /**
     * @param value Specifies the default access mode of queries through associated private endpoints in scope. If not specified default value is 'Open'. You can override this default setting for a specific private endpoint connection by adding an exclusion in the 'exclusions' array.
     */
    @JvmName("fhbkhltudfusnafg")
    public suspend fun queryAccessMode(`value`: Output<Either<String, AccessMode>>) {
        this.queryAccessMode = value
    }

    /**
     * @param value List of exclusions that override the default access mode settings for specific private endpoint connections.
     */
    @JvmName("pehqtnveqbgnkrdi")
    public suspend fun exclusions(`value`: List<AccessModeSettingsExclusionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclusions = mapped
    }

    /**
     * @param argument List of exclusions that override the default access mode settings for specific private endpoint connections.
     */
    @JvmName("pgxisohxcqyybjuy")
    public suspend
    fun exclusions(argument: List<suspend AccessModeSettingsExclusionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AccessModeSettingsExclusionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.exclusions = mapped
    }

    /**
     * @param argument List of exclusions that override the default access mode settings for specific private endpoint connections.
     */
    @JvmName("blbvgucnmrklfend")
    public suspend fun exclusions(
        vararg
        argument: suspend AccessModeSettingsExclusionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AccessModeSettingsExclusionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.exclusions = mapped
    }

    /**
     * @param argument List of exclusions that override the default access mode settings for specific private endpoint connections.
     */
    @JvmName("qjiaeiwccvrvivri")
    public suspend
    fun exclusions(argument: suspend AccessModeSettingsExclusionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AccessModeSettingsExclusionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.exclusions = mapped
    }

    /**
     * @param values List of exclusions that override the default access mode settings for specific private endpoint connections.
     */
    @JvmName("rbkkyisyuejnbpmh")
    public suspend fun exclusions(vararg values: AccessModeSettingsExclusionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exclusions = mapped
    }

    /**
     * @param value Specifies the default access mode of ingestion through associated private endpoints in scope. If not specified default value is 'Open'. You can override this default setting for a specific private endpoint connection by adding an exclusion in the 'exclusions' array.
     */
    @JvmName("cmcqfhxdjkaxvcms")
    public suspend fun ingestionAccessMode(`value`: Either<String, AccessMode>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingestionAccessMode = mapped
    }

    /**
     * @param value Specifies the default access mode of ingestion through associated private endpoints in scope. If not specified default value is 'Open'. You can override this default setting for a specific private endpoint connection by adding an exclusion in the 'exclusions' array.
     */
    @JvmName("dbuodupciulupoab")
    public fun ingestionAccessMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AccessMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingestionAccessMode = mapped
    }

    /**
     * @param value Specifies the default access mode of ingestion through associated private endpoints in scope. If not specified default value is 'Open'. You can override this default setting for a specific private endpoint connection by adding an exclusion in the 'exclusions' array.
     */
    @JvmName("bxevplccmbkmtxwc")
    public fun ingestionAccessMode(`value`: AccessMode) {
        val toBeMapped = Either.ofRight<String, AccessMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingestionAccessMode = mapped
    }

    /**
     * @param value Specifies the default access mode of queries through associated private endpoints in scope. If not specified default value is 'Open'. You can override this default setting for a specific private endpoint connection by adding an exclusion in the 'exclusions' array.
     */
    @JvmName("ewetacjyxgugvtwp")
    public suspend fun queryAccessMode(`value`: Either<String, AccessMode>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryAccessMode = mapped
    }

    /**
     * @param value Specifies the default access mode of queries through associated private endpoints in scope. If not specified default value is 'Open'. You can override this default setting for a specific private endpoint connection by adding an exclusion in the 'exclusions' array.
     */
    @JvmName("mjoacweiswicqeys")
    public fun queryAccessMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AccessMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryAccessMode = mapped
    }

    /**
     * @param value Specifies the default access mode of queries through associated private endpoints in scope. If not specified default value is 'Open'. You can override this default setting for a specific private endpoint connection by adding an exclusion in the 'exclusions' array.
     */
    @JvmName("qgweywvrkoalqoyk")
    public fun queryAccessMode(`value`: AccessMode) {
        val toBeMapped = Either.ofRight<String, AccessMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryAccessMode = mapped
    }

    internal fun build(): AccessModeSettingsArgs = AccessModeSettingsArgs(
        exclusions = exclusions,
        ingestionAccessMode = ingestionAccessMode ?: throw PulumiNullFieldException("ingestionAccessMode"),
        queryAccessMode = queryAccessMode ?: throw PulumiNullFieldException("queryAccessMode"),
    )
}
