@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.AccessModeSettingsExclusionArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.AccessMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties that define the scope private link mode settings exclusion item. This setting applies to a specific private endpoint connection and overrides the default settings for that private endpoint connection.
 * @property ingestionAccessMode Specifies the access mode of ingestion through the specified private endpoint connection in the exclusion.
 * @property privateEndpointConnectionName The private endpoint connection name associated to the private endpoint on which we want to apply the specific access mode settings.
 * @property queryAccessMode Specifies the access mode of queries through the specified private endpoint connection in the exclusion.
 */
public data class AccessModeSettingsExclusionArgs(
    public val ingestionAccessMode: Output<Either<String, AccessMode>>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val queryAccessMode: Output<Either<String, AccessMode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.AccessModeSettingsExclusionArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.AccessModeSettingsExclusionArgs =
        com.pulumi.azurenative.insights.inputs.AccessModeSettingsExclusionArgs.builder()
            .ingestionAccessMode(
                ingestionAccessMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .queryAccessMode(
                queryAccessMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [AccessModeSettingsExclusionArgs].
 */
@PulumiTagMarker
public class AccessModeSettingsExclusionArgsBuilder internal constructor() {
    private var ingestionAccessMode: Output<Either<String, AccessMode>>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var queryAccessMode: Output<Either<String, AccessMode>>? = null

    /**
     * @param value Specifies the access mode of ingestion through the specified private endpoint connection in the exclusion.
     */
    @JvmName("osbwhoknsmodadfn")
    public suspend fun ingestionAccessMode(`value`: Output<Either<String, AccessMode>>) {
        this.ingestionAccessMode = value
    }

    /**
     * @param value The private endpoint connection name associated to the private endpoint on which we want to apply the specific access mode settings.
     */
    @JvmName("mrynvfxjriittlni")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value Specifies the access mode of queries through the specified private endpoint connection in the exclusion.
     */
    @JvmName("gddpypefqexwmkup")
    public suspend fun queryAccessMode(`value`: Output<Either<String, AccessMode>>) {
        this.queryAccessMode = value
    }

    /**
     * @param value Specifies the access mode of ingestion through the specified private endpoint connection in the exclusion.
     */
    @JvmName("rqqchrpdavreowhk")
    public suspend fun ingestionAccessMode(`value`: Either<String, AccessMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingestionAccessMode = mapped
    }

    /**
     * @param value Specifies the access mode of ingestion through the specified private endpoint connection in the exclusion.
     */
    @JvmName("dthyefxmwlnrrgdh")
    public fun ingestionAccessMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AccessMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingestionAccessMode = mapped
    }

    /**
     * @param value Specifies the access mode of ingestion through the specified private endpoint connection in the exclusion.
     */
    @JvmName("jmwwqxkylhlomkio")
    public fun ingestionAccessMode(`value`: AccessMode) {
        val toBeMapped = Either.ofRight<String, AccessMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingestionAccessMode = mapped
    }

    /**
     * @param value The private endpoint connection name associated to the private endpoint on which we want to apply the specific access mode settings.
     */
    @JvmName("bsodhgqnlxruynir")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value Specifies the access mode of queries through the specified private endpoint connection in the exclusion.
     */
    @JvmName("wahechmrnwcwnsnb")
    public suspend fun queryAccessMode(`value`: Either<String, AccessMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryAccessMode = mapped
    }

    /**
     * @param value Specifies the access mode of queries through the specified private endpoint connection in the exclusion.
     */
    @JvmName("glnlirrsgqnbipdn")
    public fun queryAccessMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AccessMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryAccessMode = mapped
    }

    /**
     * @param value Specifies the access mode of queries through the specified private endpoint connection in the exclusion.
     */
    @JvmName("srefiixoedqrerfw")
    public fun queryAccessMode(`value`: AccessMode) {
        val toBeMapped = Either.ofRight<String, AccessMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryAccessMode = mapped
    }

    internal fun build(): AccessModeSettingsExclusionArgs = AccessModeSettingsExclusionArgs(
        ingestionAccessMode = ingestionAccessMode,
        privateEndpointConnectionName = privateEndpointConnectionName,
        queryAccessMode = queryAccessMode,
    )
}
