@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.ActionGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A pointer to an Azure Action Group.
 * @property actionGroupId The resource ID of the Action Group. This cannot be null or empty.
 * @property actionProperties Predefined list of properties and configuration items for the action group.
 * @property webhookProperties the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
 */
public data class ActionGroupArgs(
    public val actionGroupId: Output<String>,
    public val actionProperties: Output<Map<String, String>>? = null,
    public val webhookProperties: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.ActionGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.ActionGroupArgs =
        com.pulumi.azurenative.insights.inputs.ActionGroupArgs.builder()
            .actionGroupId(actionGroupId.applyValue({ args0 -> args0 }))
            .actionProperties(
                actionProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .webhookProperties(
                webhookProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ActionGroupArgs].
 */
@PulumiTagMarker
public class ActionGroupArgsBuilder internal constructor() {
    private var actionGroupId: Output<String>? = null

    private var actionProperties: Output<Map<String, String>>? = null

    private var webhookProperties: Output<Map<String, String>>? = null

    /**
     * @param value The resource ID of the Action Group. This cannot be null or empty.
     */
    @JvmName("dblclqrmpuqyihub")
    public suspend fun actionGroupId(`value`: Output<String>) {
        this.actionGroupId = value
    }

    /**
     * @param value Predefined list of properties and configuration items for the action group.
     */
    @JvmName("aidrpjdxpxgactdl")
    public suspend fun actionProperties(`value`: Output<Map<String, String>>) {
        this.actionProperties = value
    }

    /**
     * @param value the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
     */
    @JvmName("kuyoawouhifwgkjn")
    public suspend fun webhookProperties(`value`: Output<Map<String, String>>) {
        this.webhookProperties = value
    }

    /**
     * @param value The resource ID of the Action Group. This cannot be null or empty.
     */
    @JvmName("vuikyfyglhejotrk")
    public suspend fun actionGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionGroupId = mapped
    }

    /**
     * @param value Predefined list of properties and configuration items for the action group.
     */
    @JvmName("akmljnniaddmorxk")
    public suspend fun actionProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionProperties = mapped
    }

    /**
     * @param values Predefined list of properties and configuration items for the action group.
     */
    @JvmName("clfujwqkeqjfpmdu")
    public fun actionProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionProperties = mapped
    }

    /**
     * @param value the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
     */
    @JvmName("khtanbktrebwybfk")
    public suspend fun webhookProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhookProperties = mapped
    }

    /**
     * @param values the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
     */
    @JvmName("waxuyiroaprgucwp")
    public fun webhookProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.webhookProperties = mapped
    }

    internal fun build(): ActionGroupArgs = ActionGroupArgs(
        actionGroupId = actionGroupId ?: throw PulumiNullFieldException("actionGroupId"),
        actionProperties = actionProperties,
        webhookProperties = webhookProperties,
    )
}
