@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.ActionListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A list of Activity Log Alert rule actions.
 * @property actionGroups The list of the Action Groups.
 */
public data class ActionListArgs(
    public val actionGroups: Output<List<ActionGroupArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.ActionListArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.ActionListArgs =
        com.pulumi.azurenative.insights.inputs.ActionListArgs.builder()
            .actionGroups(
                actionGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ActionListArgs].
 */
@PulumiTagMarker
public class ActionListArgsBuilder internal constructor() {
    private var actionGroups: Output<List<ActionGroupArgs>>? = null

    /**
     * @param value The list of the Action Groups.
     */
    @JvmName("rqjdmdoboftdspga")
    public suspend fun actionGroups(`value`: Output<List<ActionGroupArgs>>) {
        this.actionGroups = value
    }

    @JvmName("vypqvjsefnbnbcug")
    public suspend fun actionGroups(vararg values: Output<ActionGroupArgs>) {
        this.actionGroups = Output.all(values.asList())
    }

    /**
     * @param values The list of the Action Groups.
     */
    @JvmName("fyhutnujlgchteba")
    public suspend fun actionGroups(values: List<Output<ActionGroupArgs>>) {
        this.actionGroups = Output.all(values)
    }

    /**
     * @param value The list of the Action Groups.
     */
    @JvmName("goenbvumkubdttkx")
    public suspend fun actionGroups(`value`: List<ActionGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionGroups = mapped
    }

    /**
     * @param argument The list of the Action Groups.
     */
    @JvmName("cpuntxanfkvyoupn")
    public suspend fun actionGroups(argument: List<suspend ActionGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ActionGroupArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.actionGroups = mapped
    }

    /**
     * @param argument The list of the Action Groups.
     */
    @JvmName("sghdnfpnneervwcf")
    public suspend fun actionGroups(vararg argument: suspend ActionGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ActionGroupArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.actionGroups = mapped
    }

    /**
     * @param argument The list of the Action Groups.
     */
    @JvmName("kigxncqmskgufacw")
    public suspend fun actionGroups(argument: suspend ActionGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ActionGroupArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.actionGroups = mapped
    }

    /**
     * @param values The list of the Action Groups.
     */
    @JvmName("bqfgwauhlifvrasp")
    public suspend fun actionGroups(vararg values: ActionGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionGroups = mapped
    }

    internal fun build(): ActionListArgs = ActionListArgs(
        actionGroups = actionGroups,
    )
}
