@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.ApplicationInsightsComponentAnalyticsItemPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A set of properties that can be defined in the context of a specific item type. Each type may have its own properties.
 * @property functionAlias A function alias, used when the type of the item is Function
 */
public data class ApplicationInsightsComponentAnalyticsItemPropertiesArgs(
    public val functionAlias: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.insights.inputs.ApplicationInsightsComponentAnalyticsItemPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.insights.inputs.ApplicationInsightsComponentAnalyticsItemPropertiesArgs =
        com.pulumi.azurenative.insights.inputs.ApplicationInsightsComponentAnalyticsItemPropertiesArgs.builder()
            .functionAlias(functionAlias?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationInsightsComponentAnalyticsItemPropertiesArgs].
 */
@PulumiTagMarker
public class ApplicationInsightsComponentAnalyticsItemPropertiesArgsBuilder internal constructor() {
    private var functionAlias: Output<String>? = null

    /**
     * @param value A function alias, used when the type of the item is Function
     */
    @JvmName("vwyqilvhracesjtm")
    public suspend fun functionAlias(`value`: Output<String>) {
        this.functionAlias = value
    }

    /**
     * @param value A function alias, used when the type of the item is Function
     */
    @JvmName("xuxbodpebgpuxfcl")
    public suspend fun functionAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionAlias = mapped
    }

    internal fun build(): ApplicationInsightsComponentAnalyticsItemPropertiesArgs =
        ApplicationInsightsComponentAnalyticsItemPropertiesArgs(
            functionAlias = functionAlias,
        )
}
