@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.ArmRoleReceiverArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An arm role receiver.
 * @property name The name of the arm role receiver. Names must be unique across all receivers within an action group.
 * @property roleId The arm role id.
 * @property useCommonAlertSchema Indicates whether to use common alert schema.
 */
public data class ArmRoleReceiverArgs(
    public val name: Output<String>,
    public val roleId: Output<String>,
    public val useCommonAlertSchema: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.ArmRoleReceiverArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.ArmRoleReceiverArgs =
        com.pulumi.azurenative.insights.inputs.ArmRoleReceiverArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .roleId(roleId.applyValue({ args0 -> args0 }))
            .useCommonAlertSchema(useCommonAlertSchema?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ArmRoleReceiverArgs].
 */
@PulumiTagMarker
public class ArmRoleReceiverArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var roleId: Output<String>? = null

    private var useCommonAlertSchema: Output<Boolean>? = null

    /**
     * @param value The name of the arm role receiver. Names must be unique across all receivers within an action group.
     */
    @JvmName("mfynqosetcesdemj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The arm role id.
     */
    @JvmName("pvdspyowhbvhqdna")
    public suspend fun roleId(`value`: Output<String>) {
        this.roleId = value
    }

    /**
     * @param value Indicates whether to use common alert schema.
     */
    @JvmName("xnlrbxgtskqnwbcn")
    public suspend fun useCommonAlertSchema(`value`: Output<Boolean>) {
        this.useCommonAlertSchema = value
    }

    /**
     * @param value The name of the arm role receiver. Names must be unique across all receivers within an action group.
     */
    @JvmName("jqglvtvnvtpyjwlc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The arm role id.
     */
    @JvmName("mlcslitrkdoljajv")
    public suspend fun roleId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleId = mapped
    }

    /**
     * @param value Indicates whether to use common alert schema.
     */
    @JvmName("iofobbgfiakjkjdd")
    public suspend fun useCommonAlertSchema(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useCommonAlertSchema = mapped
    }

    internal fun build(): ArmRoleReceiverArgs = ArmRoleReceiverArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        roleId = roleId ?: throw PulumiNullFieldException("roleId"),
        useCommonAlertSchema = useCommonAlertSchema,
    )
}
