@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.AutomationRunbookReceiverArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Azure Automation Runbook notification receiver.
 * @property automationAccountId The Azure automation account Id which holds this runbook and authenticate to Azure resource.
 * @property isGlobalRunbook Indicates whether this instance is global runbook.
 * @property name Indicates name of the webhook.
 * @property runbookName The name for this runbook.
 * @property serviceUri The URI where webhooks should be sent.
 * @property useCommonAlertSchema Indicates whether to use common alert schema.
 * @property webhookResourceId The resource id for webhook linked to this runbook.
 */
public data class AutomationRunbookReceiverArgs(
    public val automationAccountId: Output<String>,
    public val isGlobalRunbook: Output<Boolean>,
    public val name: Output<String>? = null,
    public val runbookName: Output<String>,
    public val serviceUri: Output<String>? = null,
    public val useCommonAlertSchema: Output<Boolean>? = null,
    public val webhookResourceId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.AutomationRunbookReceiverArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.AutomationRunbookReceiverArgs =
        com.pulumi.azurenative.insights.inputs.AutomationRunbookReceiverArgs.builder()
            .automationAccountId(automationAccountId.applyValue({ args0 -> args0 }))
            .isGlobalRunbook(isGlobalRunbook.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .runbookName(runbookName.applyValue({ args0 -> args0 }))
            .serviceUri(serviceUri?.applyValue({ args0 -> args0 }))
            .useCommonAlertSchema(useCommonAlertSchema?.applyValue({ args0 -> args0 }))
            .webhookResourceId(webhookResourceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutomationRunbookReceiverArgs].
 */
@PulumiTagMarker
public class AutomationRunbookReceiverArgsBuilder internal constructor() {
    private var automationAccountId: Output<String>? = null

    private var isGlobalRunbook: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var runbookName: Output<String>? = null

    private var serviceUri: Output<String>? = null

    private var useCommonAlertSchema: Output<Boolean>? = null

    private var webhookResourceId: Output<String>? = null

    /**
     * @param value The Azure automation account Id which holds this runbook and authenticate to Azure resource.
     */
    @JvmName("qwahrxrgmxymiqpd")
    public suspend fun automationAccountId(`value`: Output<String>) {
        this.automationAccountId = value
    }

    /**
     * @param value Indicates whether this instance is global runbook.
     */
    @JvmName("vwwxqdfetibdojeh")
    public suspend fun isGlobalRunbook(`value`: Output<Boolean>) {
        this.isGlobalRunbook = value
    }

    /**
     * @param value Indicates name of the webhook.
     */
    @JvmName("osvcacvuuiyrxvte")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name for this runbook.
     */
    @JvmName("vfsotwhfoqgjoyko")
    public suspend fun runbookName(`value`: Output<String>) {
        this.runbookName = value
    }

    /**
     * @param value The URI where webhooks should be sent.
     */
    @JvmName("klahsrqexynxaxyw")
    public suspend fun serviceUri(`value`: Output<String>) {
        this.serviceUri = value
    }

    /**
     * @param value Indicates whether to use common alert schema.
     */
    @JvmName("hjckjyggclymrwlx")
    public suspend fun useCommonAlertSchema(`value`: Output<Boolean>) {
        this.useCommonAlertSchema = value
    }

    /**
     * @param value The resource id for webhook linked to this runbook.
     */
    @JvmName("nvwhtltxdklmflsr")
    public suspend fun webhookResourceId(`value`: Output<String>) {
        this.webhookResourceId = value
    }

    /**
     * @param value The Azure automation account Id which holds this runbook and authenticate to Azure resource.
     */
    @JvmName("idvkkdcxadhmedxs")
    public suspend fun automationAccountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.automationAccountId = mapped
    }

    /**
     * @param value Indicates whether this instance is global runbook.
     */
    @JvmName("uoqnrddwhgsyqhci")
    public suspend fun isGlobalRunbook(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isGlobalRunbook = mapped
    }

    /**
     * @param value Indicates name of the webhook.
     */
    @JvmName("wuvkwduqxnkicyaa")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name for this runbook.
     */
    @JvmName("rnajyffsplemoqoa")
    public suspend fun runbookName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.runbookName = mapped
    }

    /**
     * @param value The URI where webhooks should be sent.
     */
    @JvmName("ksndhnofurypfesb")
    public suspend fun serviceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceUri = mapped
    }

    /**
     * @param value Indicates whether to use common alert schema.
     */
    @JvmName("gwsjacmpiiqmebbd")
    public suspend fun useCommonAlertSchema(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useCommonAlertSchema = mapped
    }

    /**
     * @param value The resource id for webhook linked to this runbook.
     */
    @JvmName("smyhkhxvducxbpke")
    public suspend fun webhookResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.webhookResourceId = mapped
    }

    internal fun build(): AutomationRunbookReceiverArgs = AutomationRunbookReceiverArgs(
        automationAccountId = automationAccountId ?: throw PulumiNullFieldException("automationAccountId"),
        isGlobalRunbook = isGlobalRunbook ?: throw PulumiNullFieldException("isGlobalRunbook"),
        name = name,
        runbookName = runbookName ?: throw PulumiNullFieldException("runbookName"),
        serviceUri = serviceUri,
        useCommonAlertSchema = useCommonAlertSchema,
        webhookResourceId = webhookResourceId ?: throw PulumiNullFieldException("webhookResourceId"),
    )
}
