@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.DataCollectionRuleDestinationsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The specification of destinations.
 * @property azureMonitorMetrics Azure Monitor Metrics destination.
 * @property eventHubs List of Event Hubs destinations.
 * @property eventHubsDirect List of Event Hubs Direct destinations.
 * @property logAnalytics List of Log Analytics destinations.
 * @property monitoringAccounts List of monitoring account destinations.
 * @property storageAccounts List of storage accounts destinations.
 * @property storageBlobsDirect List of Storage Blob Direct destinations. To be used only for sending data directly to store from the agent.
 * @property storageTablesDirect List of Storage Table Direct destinations.
 */
public data class DataCollectionRuleDestinationsArgs(
    public val azureMonitorMetrics: Output<DestinationsSpecAzureMonitorMetricsArgs>? = null,
    public val eventHubs: Output<List<EventHubDestinationArgs>>? = null,
    public val eventHubsDirect: Output<List<EventHubDirectDestinationArgs>>? = null,
    public val logAnalytics: Output<List<LogAnalyticsDestinationArgs>>? = null,
    public val monitoringAccounts: Output<List<MonitoringAccountDestinationArgs>>? = null,
    public val storageAccounts: Output<List<StorageBlobDestinationArgs>>? = null,
    public val storageBlobsDirect: Output<List<StorageBlobDestinationArgs>>? = null,
    public val storageTablesDirect: Output<List<StorageTableDestinationArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.DataCollectionRuleDestinationsArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.DataCollectionRuleDestinationsArgs =
        com.pulumi.azurenative.insights.inputs.DataCollectionRuleDestinationsArgs.builder()
            .azureMonitorMetrics(
                azureMonitorMetrics?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .eventHubs(
                eventHubs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .eventHubsDirect(
                eventHubsDirect?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .logAnalytics(
                logAnalytics?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .monitoringAccounts(
                monitoringAccounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .storageAccounts(
                storageAccounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .storageBlobsDirect(
                storageBlobsDirect?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .storageTablesDirect(
                storageTablesDirect?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DataCollectionRuleDestinationsArgs].
 */
@PulumiTagMarker
public class DataCollectionRuleDestinationsArgsBuilder internal constructor() {
    private var azureMonitorMetrics: Output<DestinationsSpecAzureMonitorMetricsArgs>? = null

    private var eventHubs: Output<List<EventHubDestinationArgs>>? = null

    private var eventHubsDirect: Output<List<EventHubDirectDestinationArgs>>? = null

    private var logAnalytics: Output<List<LogAnalyticsDestinationArgs>>? = null

    private var monitoringAccounts: Output<List<MonitoringAccountDestinationArgs>>? = null

    private var storageAccounts: Output<List<StorageBlobDestinationArgs>>? = null

    private var storageBlobsDirect: Output<List<StorageBlobDestinationArgs>>? = null

    private var storageTablesDirect: Output<List<StorageTableDestinationArgs>>? = null

    /**
     * @param value Azure Monitor Metrics destination.
     */
    @JvmName("reegupmfjtajalpm")
    public suspend fun azureMonitorMetrics(`value`: Output<DestinationsSpecAzureMonitorMetricsArgs>) {
        this.azureMonitorMetrics = value
    }

    /**
     * @param value List of Event Hubs destinations.
     */
    @JvmName("wgcdxgvyfrhdmgwr")
    public suspend fun eventHubs(`value`: Output<List<EventHubDestinationArgs>>) {
        this.eventHubs = value
    }

    @JvmName("bxcxtqivstaipwqw")
    public suspend fun eventHubs(vararg values: Output<EventHubDestinationArgs>) {
        this.eventHubs = Output.all(values.asList())
    }

    /**
     * @param values List of Event Hubs destinations.
     */
    @JvmName("kgkkntvrotcgcuqj")
    public suspend fun eventHubs(values: List<Output<EventHubDestinationArgs>>) {
        this.eventHubs = Output.all(values)
    }

    /**
     * @param value List of Event Hubs Direct destinations.
     */
    @JvmName("cerrgdiyksrejaoj")
    public suspend fun eventHubsDirect(`value`: Output<List<EventHubDirectDestinationArgs>>) {
        this.eventHubsDirect = value
    }

    @JvmName("ppufupkifxppkkps")
    public suspend fun eventHubsDirect(vararg values: Output<EventHubDirectDestinationArgs>) {
        this.eventHubsDirect = Output.all(values.asList())
    }

    /**
     * @param values List of Event Hubs Direct destinations.
     */
    @JvmName("ttjpamvsacfojqyt")
    public suspend fun eventHubsDirect(values: List<Output<EventHubDirectDestinationArgs>>) {
        this.eventHubsDirect = Output.all(values)
    }

    /**
     * @param value List of Log Analytics destinations.
     */
    @JvmName("wonpwrnnrsgrmhnd")
    public suspend fun logAnalytics(`value`: Output<List<LogAnalyticsDestinationArgs>>) {
        this.logAnalytics = value
    }

    @JvmName("dopqfmhivwhjvkki")
    public suspend fun logAnalytics(vararg values: Output<LogAnalyticsDestinationArgs>) {
        this.logAnalytics = Output.all(values.asList())
    }

    /**
     * @param values List of Log Analytics destinations.
     */
    @JvmName("kkcanpocusqiiaja")
    public suspend fun logAnalytics(values: List<Output<LogAnalyticsDestinationArgs>>) {
        this.logAnalytics = Output.all(values)
    }

    /**
     * @param value List of monitoring account destinations.
     */
    @JvmName("aoihimlmxpcbqyhw")
    public suspend fun monitoringAccounts(`value`: Output<List<MonitoringAccountDestinationArgs>>) {
        this.monitoringAccounts = value
    }

    @JvmName("yfftpjnndeviemol")
    public suspend fun monitoringAccounts(vararg values: Output<MonitoringAccountDestinationArgs>) {
        this.monitoringAccounts = Output.all(values.asList())
    }

    /**
     * @param values List of monitoring account destinations.
     */
    @JvmName("wupvsajawhjoiqrt")
    public suspend fun monitoringAccounts(values: List<Output<MonitoringAccountDestinationArgs>>) {
        this.monitoringAccounts = Output.all(values)
    }

    /**
     * @param value List of storage accounts destinations.
     */
    @JvmName("sohtspfwcchnucyt")
    public suspend fun storageAccounts(`value`: Output<List<StorageBlobDestinationArgs>>) {
        this.storageAccounts = value
    }

    @JvmName("pxdnxbfwigqihrqf")
    public suspend fun storageAccounts(vararg values: Output<StorageBlobDestinationArgs>) {
        this.storageAccounts = Output.all(values.asList())
    }

    /**
     * @param values List of storage accounts destinations.
     */
    @JvmName("cxgxdfbnqvlrkuae")
    public suspend fun storageAccounts(values: List<Output<StorageBlobDestinationArgs>>) {
        this.storageAccounts = Output.all(values)
    }

    /**
     * @param value List of Storage Blob Direct destinations. To be used only for sending data directly to store from the agent.
     */
    @JvmName("yprirpbhyhhxectq")
    public suspend fun storageBlobsDirect(`value`: Output<List<StorageBlobDestinationArgs>>) {
        this.storageBlobsDirect = value
    }

    @JvmName("pgmemwoeoorsxuob")
    public suspend fun storageBlobsDirect(vararg values: Output<StorageBlobDestinationArgs>) {
        this.storageBlobsDirect = Output.all(values.asList())
    }

    /**
     * @param values List of Storage Blob Direct destinations. To be used only for sending data directly to store from the agent.
     */
    @JvmName("fdrmtbxrlurjyxhb")
    public suspend fun storageBlobsDirect(values: List<Output<StorageBlobDestinationArgs>>) {
        this.storageBlobsDirect = Output.all(values)
    }

    /**
     * @param value List of Storage Table Direct destinations.
     */
    @JvmName("xgkhmbngodpthuha")
    public suspend fun storageTablesDirect(`value`: Output<List<StorageTableDestinationArgs>>) {
        this.storageTablesDirect = value
    }

    @JvmName("tcimyrvjptonoutq")
    public suspend fun storageTablesDirect(vararg values: Output<StorageTableDestinationArgs>) {
        this.storageTablesDirect = Output.all(values.asList())
    }

    /**
     * @param values List of Storage Table Direct destinations.
     */
    @JvmName("jlnhugcygoprmidu")
    public suspend fun storageTablesDirect(values: List<Output<StorageTableDestinationArgs>>) {
        this.storageTablesDirect = Output.all(values)
    }

    /**
     * @param value Azure Monitor Metrics destination.
     */
    @JvmName("itmrjsaoussyoaht")
    public suspend fun azureMonitorMetrics(`value`: DestinationsSpecAzureMonitorMetricsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureMonitorMetrics = mapped
    }

    /**
     * @param argument Azure Monitor Metrics destination.
     */
    @JvmName("ygeohupndwmxowhk")
    public suspend
    fun azureMonitorMetrics(argument: suspend DestinationsSpecAzureMonitorMetricsArgsBuilder.() -> Unit) {
        val toBeMapped = DestinationsSpecAzureMonitorMetricsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.azureMonitorMetrics = mapped
    }

    /**
     * @param value List of Event Hubs destinations.
     */
    @JvmName("cxcgdlfabbxxbyso")
    public suspend fun eventHubs(`value`: List<EventHubDestinationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubs = mapped
    }

    /**
     * @param argument List of Event Hubs destinations.
     */
    @JvmName("jnvwaobcigsuketd")
    public suspend fun eventHubs(argument: List<suspend EventHubDestinationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventHubDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.eventHubs = mapped
    }

    /**
     * @param argument List of Event Hubs destinations.
     */
    @JvmName("ngumkyonmjepbggc")
    public suspend fun eventHubs(vararg argument: suspend EventHubDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EventHubDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.eventHubs = mapped
    }

    /**
     * @param argument List of Event Hubs destinations.
     */
    @JvmName("wnhacgtlumakldjl")
    public suspend fun eventHubs(argument: suspend EventHubDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EventHubDestinationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.eventHubs = mapped
    }

    /**
     * @param values List of Event Hubs destinations.
     */
    @JvmName("vpnseritiblykbtf")
    public suspend fun eventHubs(vararg values: EventHubDestinationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventHubs = mapped
    }

    /**
     * @param value List of Event Hubs Direct destinations.
     */
    @JvmName("hvpglnlhfkkaqexj")
    public suspend fun eventHubsDirect(`value`: List<EventHubDirectDestinationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubsDirect = mapped
    }

    /**
     * @param argument List of Event Hubs Direct destinations.
     */
    @JvmName("hargfsuseieduudw")
    public suspend
    fun eventHubsDirect(argument: List<suspend EventHubDirectDestinationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventHubDirectDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.eventHubsDirect = mapped
    }

    /**
     * @param argument List of Event Hubs Direct destinations.
     */
    @JvmName("hvhlfbfgfkvsjaxd")
    public suspend fun eventHubsDirect(
        vararg
        argument: suspend EventHubDirectDestinationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EventHubDirectDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.eventHubsDirect = mapped
    }

    /**
     * @param argument List of Event Hubs Direct destinations.
     */
    @JvmName("hhvvbrohxonipipf")
    public suspend
    fun eventHubsDirect(argument: suspend EventHubDirectDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EventHubDirectDestinationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.eventHubsDirect = mapped
    }

    /**
     * @param values List of Event Hubs Direct destinations.
     */
    @JvmName("rbegxgfrwhorsiun")
    public suspend fun eventHubsDirect(vararg values: EventHubDirectDestinationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventHubsDirect = mapped
    }

    /**
     * @param value List of Log Analytics destinations.
     */
    @JvmName("gqaninyxjgbonumi")
    public suspend fun logAnalytics(`value`: List<LogAnalyticsDestinationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logAnalytics = mapped
    }

    /**
     * @param argument List of Log Analytics destinations.
     */
    @JvmName("ffjyjhprcpqmowyo")
    public suspend
    fun logAnalytics(argument: List<suspend LogAnalyticsDestinationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LogAnalyticsDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.logAnalytics = mapped
    }

    /**
     * @param argument List of Log Analytics destinations.
     */
    @JvmName("unsvrhxwkhjijksf")
    public suspend fun logAnalytics(
        vararg
        argument: suspend LogAnalyticsDestinationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LogAnalyticsDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.logAnalytics = mapped
    }

    /**
     * @param argument List of Log Analytics destinations.
     */
    @JvmName("qitpggavlsosdhel")
    public suspend fun logAnalytics(argument: suspend LogAnalyticsDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LogAnalyticsDestinationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.logAnalytics = mapped
    }

    /**
     * @param values List of Log Analytics destinations.
     */
    @JvmName("lnvmmvwmmikmvcmu")
    public suspend fun logAnalytics(vararg values: LogAnalyticsDestinationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logAnalytics = mapped
    }

    /**
     * @param value List of monitoring account destinations.
     */
    @JvmName("devoshedyeyysyuy")
    public suspend fun monitoringAccounts(`value`: List<MonitoringAccountDestinationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoringAccounts = mapped
    }

    /**
     * @param argument List of monitoring account destinations.
     */
    @JvmName("sisirckxntsmnnwc")
    public suspend
    fun monitoringAccounts(argument: List<suspend MonitoringAccountDestinationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MonitoringAccountDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.monitoringAccounts = mapped
    }

    /**
     * @param argument List of monitoring account destinations.
     */
    @JvmName("lxlpfoyebgoamwup")
    public suspend fun monitoringAccounts(
        vararg
        argument: suspend MonitoringAccountDestinationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MonitoringAccountDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.monitoringAccounts = mapped
    }

    /**
     * @param argument List of monitoring account destinations.
     */
    @JvmName("kuqpjmpyhurmpggb")
    public suspend
    fun monitoringAccounts(argument: suspend MonitoringAccountDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MonitoringAccountDestinationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.monitoringAccounts = mapped
    }

    /**
     * @param values List of monitoring account destinations.
     */
    @JvmName("wwulfyamuqouugof")
    public suspend fun monitoringAccounts(vararg values: MonitoringAccountDestinationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monitoringAccounts = mapped
    }

    /**
     * @param value List of storage accounts destinations.
     */
    @JvmName("cyfypadiwdtrgaen")
    public suspend fun storageAccounts(`value`: List<StorageBlobDestinationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccounts = mapped
    }

    /**
     * @param argument List of storage accounts destinations.
     */
    @JvmName("icnkmpumphicqxuw")
    public suspend
    fun storageAccounts(argument: List<suspend StorageBlobDestinationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StorageBlobDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageAccounts = mapped
    }

    /**
     * @param argument List of storage accounts destinations.
     */
    @JvmName("iosvvbiwblpcsdnh")
    public suspend fun storageAccounts(
        vararg
        argument: suspend StorageBlobDestinationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StorageBlobDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageAccounts = mapped
    }

    /**
     * @param argument List of storage accounts destinations.
     */
    @JvmName("bqhqrjgeduqnrjpm")
    public suspend
    fun storageAccounts(argument: suspend StorageBlobDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StorageBlobDestinationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.storageAccounts = mapped
    }

    /**
     * @param values List of storage accounts destinations.
     */
    @JvmName("ryuklgdicbejbjtt")
    public suspend fun storageAccounts(vararg values: StorageBlobDestinationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccounts = mapped
    }

    /**
     * @param value List of Storage Blob Direct destinations. To be used only for sending data directly to store from the agent.
     */
    @JvmName("svhnpjlpipksuuds")
    public suspend fun storageBlobsDirect(`value`: List<StorageBlobDestinationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageBlobsDirect = mapped
    }

    /**
     * @param argument List of Storage Blob Direct destinations. To be used only for sending data directly to store from the agent.
     */
    @JvmName("pufouvmnnohabhir")
    public suspend
    fun storageBlobsDirect(argument: List<suspend StorageBlobDestinationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StorageBlobDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageBlobsDirect = mapped
    }

    /**
     * @param argument List of Storage Blob Direct destinations. To be used only for sending data directly to store from the agent.
     */
    @JvmName("cqhdbunhihbbnssu")
    public suspend fun storageBlobsDirect(
        vararg
        argument: suspend StorageBlobDestinationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StorageBlobDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageBlobsDirect = mapped
    }

    /**
     * @param argument List of Storage Blob Direct destinations. To be used only for sending data directly to store from the agent.
     */
    @JvmName("nsqxfucltjgyahqu")
    public suspend
    fun storageBlobsDirect(argument: suspend StorageBlobDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StorageBlobDestinationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.storageBlobsDirect = mapped
    }

    /**
     * @param values List of Storage Blob Direct destinations. To be used only for sending data directly to store from the agent.
     */
    @JvmName("pntusbfcnfwqblqn")
    public suspend fun storageBlobsDirect(vararg values: StorageBlobDestinationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageBlobsDirect = mapped
    }

    /**
     * @param value List of Storage Table Direct destinations.
     */
    @JvmName("ncfusxluowncqavt")
    public suspend fun storageTablesDirect(`value`: List<StorageTableDestinationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageTablesDirect = mapped
    }

    /**
     * @param argument List of Storage Table Direct destinations.
     */
    @JvmName("efckjqlpsinqhqkb")
    public suspend
    fun storageTablesDirect(argument: List<suspend StorageTableDestinationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StorageTableDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageTablesDirect = mapped
    }

    /**
     * @param argument List of Storage Table Direct destinations.
     */
    @JvmName("ownnyadlvamdvwfy")
    public suspend fun storageTablesDirect(
        vararg
        argument: suspend StorageTableDestinationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StorageTableDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageTablesDirect = mapped
    }

    /**
     * @param argument List of Storage Table Direct destinations.
     */
    @JvmName("plrcfwntdawqpbnw")
    public suspend
    fun storageTablesDirect(argument: suspend StorageTableDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            StorageTableDestinationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.storageTablesDirect = mapped
    }

    /**
     * @param values List of Storage Table Direct destinations.
     */
    @JvmName("lpnqdjowkadnpijw")
    public suspend fun storageTablesDirect(vararg values: StorageTableDestinationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageTablesDirect = mapped
    }

    internal fun build(): DataCollectionRuleDestinationsArgs = DataCollectionRuleDestinationsArgs(
        azureMonitorMetrics = azureMonitorMetrics,
        eventHubs = eventHubs,
        eventHubsDirect = eventHubsDirect,
        logAnalytics = logAnalytics,
        monitoringAccounts = monitoringAccounts,
        storageAccounts = storageAccounts,
        storageBlobsDirect = storageBlobsDirect,
        storageTablesDirect = storageTablesDirect,
    )
}
