@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.DataSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Data source object contains configuration to collect telemetry and one or more sinks to send that telemetry data to
 * @property configuration
 * @property kind Datasource kind
 * @property sinks
 */
public data class DataSourceArgs(
    public val configuration: Output<DataSourceConfigurationArgs>,
    public val kind: Output<String>,
    public val sinks: Output<List<SinkConfigurationArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.DataSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.DataSourceArgs =
        com.pulumi.azurenative.insights.inputs.DataSourceArgs.builder()
            .configuration(configuration.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind.applyValue({ args0 -> args0 }))
            .sinks(
                sinks.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DataSourceArgs].
 */
@PulumiTagMarker
public class DataSourceArgsBuilder internal constructor() {
    private var configuration: Output<DataSourceConfigurationArgs>? = null

    private var kind: Output<String>? = null

    private var sinks: Output<List<SinkConfigurationArgs>>? = null

    /**
     * @param value
     */
    @JvmName("kcbmnaehykfgftmw")
    public suspend fun configuration(`value`: Output<DataSourceConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value Datasource kind
     */
    @JvmName("hkfqacjxrktqamca")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value
     */
    @JvmName("dlhpwcefjbgyxlwb")
    public suspend fun sinks(`value`: Output<List<SinkConfigurationArgs>>) {
        this.sinks = value
    }

    @JvmName("jfhtrqhwipwwcmlw")
    public suspend fun sinks(vararg values: Output<SinkConfigurationArgs>) {
        this.sinks = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("eykyturqcinpnsbs")
    public suspend fun sinks(values: List<Output<SinkConfigurationArgs>>) {
        this.sinks = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("opiyavwfblsbkluc")
    public suspend fun configuration(`value`: DataSourceConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument
     */
    @JvmName("modeofgkogkxybuv")
    public suspend
    fun configuration(argument: suspend DataSourceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value Datasource kind
     */
    @JvmName("islupsykvsfqaomf")
    public suspend fun kind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value
     */
    @JvmName("urjftaxcsyopestr")
    public suspend fun sinks(`value`: List<SinkConfigurationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sinks = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hywfuricwepuqdhp")
    public suspend fun sinks(argument: List<suspend SinkConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SinkConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sinks = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bmnhqeisjgepxoad")
    public suspend fun sinks(vararg argument: suspend SinkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SinkConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sinks = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hvhdltyapswbmlho")
    public suspend fun sinks(argument: suspend SinkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SinkConfigurationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sinks = mapped
    }

    /**
     * @param values
     */
    @JvmName("ouaujosctaajjfwy")
    public suspend fun sinks(vararg values: SinkConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sinks = mapped
    }

    internal fun build(): DataSourceArgs = DataSourceArgs(
        configuration = configuration ?: throw PulumiNullFieldException("configuration"),
        kind = kind ?: throw PulumiNullFieldException("kind"),
        sinks = sinks ?: throw PulumiNullFieldException("sinks"),
    )
}
