@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.DynamicMetricCriteriaArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.AggregationTypeEnum
import com.pulumi.azurenative.insights.kotlin.enums.DynamicThresholdOperator
import com.pulumi.azurenative.insights.kotlin.enums.DynamicThresholdSensitivity
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Criterion for dynamic threshold.
 * @property alertSensitivity The extent of deviation required to trigger an alert. This will affect how tight the threshold is to the metric series pattern.
 * @property criterionType Specifies the type of threshold criteria
 * Expected value is 'DynamicThresholdCriterion'.
 * @property dimensions List of dimension conditions.
 * @property failingPeriods The minimum number of violations required within the selected lookback time window required to raise an alert.
 * @property ignoreDataBefore Use this option to set the date from which to start learning the metric historical data and calculate the dynamic thresholds (in ISO8601 format)
 * @property metricName Name of the metric.
 * @property metricNamespace Namespace of the metric.
 * @property name Name of the criteria.
 * @property operator The operator used to compare the metric value against the threshold.
 * @property skipMetricValidation Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
 * @property timeAggregation the criteria time aggregation types.
 */
public data class DynamicMetricCriteriaArgs(
    public val alertSensitivity: Output<Either<String, DynamicThresholdSensitivity>>,
    public val criterionType: Output<String>,
    public val dimensions: Output<List<MetricDimensionArgs>>? = null,
    public val failingPeriods: Output<DynamicThresholdFailingPeriodsArgs>,
    public val ignoreDataBefore: Output<String>? = null,
    public val metricName: Output<String>,
    public val metricNamespace: Output<String>? = null,
    public val name: Output<String>,
    public val `operator`: Output<Either<String, DynamicThresholdOperator>>,
    public val skipMetricValidation: Output<Boolean>? = null,
    public val timeAggregation: Output<Either<String, AggregationTypeEnum>>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.DynamicMetricCriteriaArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.DynamicMetricCriteriaArgs =
        com.pulumi.azurenative.insights.inputs.DynamicMetricCriteriaArgs.builder()
            .alertSensitivity(
                alertSensitivity.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .criterionType(criterionType.applyValue({ args0 -> args0 }))
            .dimensions(
                dimensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .failingPeriods(failingPeriods.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ignoreDataBefore(ignoreDataBefore?.applyValue({ args0 -> args0 }))
            .metricName(metricName.applyValue({ args0 -> args0 }))
            .metricNamespace(metricNamespace?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .`operator`(
                `operator`.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .skipMetricValidation(skipMetricValidation?.applyValue({ args0 -> args0 }))
            .timeAggregation(
                timeAggregation.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DynamicMetricCriteriaArgs].
 */
@PulumiTagMarker
public class DynamicMetricCriteriaArgsBuilder internal constructor() {
    private var alertSensitivity: Output<Either<String, DynamicThresholdSensitivity>>? = null

    private var criterionType: Output<String>? = null

    private var dimensions: Output<List<MetricDimensionArgs>>? = null

    private var failingPeriods: Output<DynamicThresholdFailingPeriodsArgs>? = null

    private var ignoreDataBefore: Output<String>? = null

    private var metricName: Output<String>? = null

    private var metricNamespace: Output<String>? = null

    private var name: Output<String>? = null

    private var `operator`: Output<Either<String, DynamicThresholdOperator>>? = null

    private var skipMetricValidation: Output<Boolean>? = null

    private var timeAggregation: Output<Either<String, AggregationTypeEnum>>? = null

    /**
     * @param value The extent of deviation required to trigger an alert. This will affect how tight the threshold is to the metric series pattern.
     */
    @JvmName("mnceaykrrqbhdgmj")
    public suspend
    fun alertSensitivity(`value`: Output<Either<String, DynamicThresholdSensitivity>>) {
        this.alertSensitivity = value
    }

    /**
     * @param value Specifies the type of threshold criteria
     * Expected value is 'DynamicThresholdCriterion'.
     */
    @JvmName("kilbipmibyicwatm")
    public suspend fun criterionType(`value`: Output<String>) {
        this.criterionType = value
    }

    /**
     * @param value List of dimension conditions.
     */
    @JvmName("pfqaaoyjovsahscj")
    public suspend fun dimensions(`value`: Output<List<MetricDimensionArgs>>) {
        this.dimensions = value
    }

    @JvmName("nfxkamxarrurplfh")
    public suspend fun dimensions(vararg values: Output<MetricDimensionArgs>) {
        this.dimensions = Output.all(values.asList())
    }

    /**
     * @param values List of dimension conditions.
     */
    @JvmName("hddmhfqbjsywslcp")
    public suspend fun dimensions(values: List<Output<MetricDimensionArgs>>) {
        this.dimensions = Output.all(values)
    }

    /**
     * @param value The minimum number of violations required within the selected lookback time window required to raise an alert.
     */
    @JvmName("ksfskivwcfvfwwhd")
    public suspend fun failingPeriods(`value`: Output<DynamicThresholdFailingPeriodsArgs>) {
        this.failingPeriods = value
    }

    /**
     * @param value Use this option to set the date from which to start learning the metric historical data and calculate the dynamic thresholds (in ISO8601 format)
     */
    @JvmName("odkmppjgodqnbkki")
    public suspend fun ignoreDataBefore(`value`: Output<String>) {
        this.ignoreDataBefore = value
    }

    /**
     * @param value Name of the metric.
     */
    @JvmName("cfvallhcobmcsoak")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value Namespace of the metric.
     */
    @JvmName("blemkiwvycdgcdhj")
    public suspend fun metricNamespace(`value`: Output<String>) {
        this.metricNamespace = value
    }

    /**
     * @param value Name of the criteria.
     */
    @JvmName("uefivcuvjauvagui")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The operator used to compare the metric value against the threshold.
     */
    @JvmName("xvaqvpyeyimrshpr")
    public suspend fun `operator`(`value`: Output<Either<String, DynamicThresholdOperator>>) {
        this.`operator` = value
    }

    /**
     * @param value Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
     */
    @JvmName("jgaibbjicgjmbnsj")
    public suspend fun skipMetricValidation(`value`: Output<Boolean>) {
        this.skipMetricValidation = value
    }

    /**
     * @param value the criteria time aggregation types.
     */
    @JvmName("bcnykgiccdttwtqq")
    public suspend fun timeAggregation(`value`: Output<Either<String, AggregationTypeEnum>>) {
        this.timeAggregation = value
    }

    /**
     * @param value The extent of deviation required to trigger an alert. This will affect how tight the threshold is to the metric series pattern.
     */
    @JvmName("prwlogyxpcpmagot")
    public suspend fun alertSensitivity(`value`: Either<String, DynamicThresholdSensitivity>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alertSensitivity = mapped
    }

    /**
     * @param value The extent of deviation required to trigger an alert. This will affect how tight the threshold is to the metric series pattern.
     */
    @JvmName("tsjdmbtbduvwrecn")
    public fun alertSensitivity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DynamicThresholdSensitivity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alertSensitivity = mapped
    }

    /**
     * @param value The extent of deviation required to trigger an alert. This will affect how tight the threshold is to the metric series pattern.
     */
    @JvmName("dtwymyxbjskmsnhe")
    public fun alertSensitivity(`value`: DynamicThresholdSensitivity) {
        val toBeMapped = Either.ofRight<String, DynamicThresholdSensitivity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alertSensitivity = mapped
    }

    /**
     * @param value Specifies the type of threshold criteria
     * Expected value is 'DynamicThresholdCriterion'.
     */
    @JvmName("lcxdxmnpxhdktpjt")
    public suspend fun criterionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.criterionType = mapped
    }

    /**
     * @param value List of dimension conditions.
     */
    @JvmName("cqexodxgshxhffmo")
    public suspend fun dimensions(`value`: List<MetricDimensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param argument List of dimension conditions.
     */
    @JvmName("dvsecimpihmuqmys")
    public suspend fun dimensions(argument: List<suspend MetricDimensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MetricDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument List of dimension conditions.
     */
    @JvmName("fgfixerrmkrbnbtu")
    public suspend fun dimensions(vararg argument: suspend MetricDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MetricDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument List of dimension conditions.
     */
    @JvmName("ejigkicprcjnlsag")
    public suspend fun dimensions(argument: suspend MetricDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MetricDimensionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param values List of dimension conditions.
     */
    @JvmName("dkxxxfogwlmdxigy")
    public suspend fun dimensions(vararg values: MetricDimensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param value The minimum number of violations required within the selected lookback time window required to raise an alert.
     */
    @JvmName("jxorfahsixlmjrjr")
    public suspend fun failingPeriods(`value`: DynamicThresholdFailingPeriodsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failingPeriods = mapped
    }

    /**
     * @param argument The minimum number of violations required within the selected lookback time window required to raise an alert.
     */
    @JvmName("sfbkiqccceltlecq")
    public suspend
    fun failingPeriods(argument: suspend DynamicThresholdFailingPeriodsArgsBuilder.() -> Unit) {
        val toBeMapped = DynamicThresholdFailingPeriodsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.failingPeriods = mapped
    }

    /**
     * @param value Use this option to set the date from which to start learning the metric historical data and calculate the dynamic thresholds (in ISO8601 format)
     */
    @JvmName("gxrbgdyjwkddswjj")
    public suspend fun ignoreDataBefore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreDataBefore = mapped
    }

    /**
     * @param value Name of the metric.
     */
    @JvmName("lgnnhhscvduolmsk")
    public suspend fun metricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value Namespace of the metric.
     */
    @JvmName("mpyhtkerdueovxkq")
    public suspend fun metricNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricNamespace = mapped
    }

    /**
     * @param value Name of the criteria.
     */
    @JvmName("qlqudoompsstfnnk")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The operator used to compare the metric value against the threshold.
     */
    @JvmName("xdribllyivrycsvv")
    public suspend fun `operator`(`value`: Either<String, DynamicThresholdOperator>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value The operator used to compare the metric value against the threshold.
     */
    @JvmName("ofqeqgygeqrwvubk")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DynamicThresholdOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value The operator used to compare the metric value against the threshold.
     */
    @JvmName("mefweblyygwtjloi")
    public fun `operator`(`value`: DynamicThresholdOperator) {
        val toBeMapped = Either.ofRight<String, DynamicThresholdOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
     */
    @JvmName("htgrkuitwelfitxy")
    public suspend fun skipMetricValidation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipMetricValidation = mapped
    }

    /**
     * @param value the criteria time aggregation types.
     */
    @JvmName("isaltsxxvlmxavps")
    public suspend fun timeAggregation(`value`: Either<String, AggregationTypeEnum>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeAggregation = mapped
    }

    /**
     * @param value the criteria time aggregation types.
     */
    @JvmName("wnooqxnoyyphpeql")
    public fun timeAggregation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AggregationTypeEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeAggregation = mapped
    }

    /**
     * @param value the criteria time aggregation types.
     */
    @JvmName("kxhwacrxbphemypq")
    public fun timeAggregation(`value`: AggregationTypeEnum) {
        val toBeMapped = Either.ofRight<String, AggregationTypeEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeAggregation = mapped
    }

    internal fun build(): DynamicMetricCriteriaArgs = DynamicMetricCriteriaArgs(
        alertSensitivity = alertSensitivity ?: throw PulumiNullFieldException("alertSensitivity"),
        criterionType = criterionType ?: throw PulumiNullFieldException("criterionType"),
        dimensions = dimensions,
        failingPeriods = failingPeriods ?: throw PulumiNullFieldException("failingPeriods"),
        ignoreDataBefore = ignoreDataBefore,
        metricName = metricName ?: throw PulumiNullFieldException("metricName"),
        metricNamespace = metricNamespace,
        name = name ?: throw PulumiNullFieldException("name"),
        `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
        skipMetricValidation = skipMetricValidation,
        timeAggregation = timeAggregation ?: throw PulumiNullFieldException("timeAggregation"),
    )
}
