@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.EmailReceiverArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An email receiver.
 * @property emailAddress The email address of this receiver.
 * @property name The name of the email receiver. Names must be unique across all receivers within a tenant action group.
 * @property useCommonAlertSchema Indicates whether to use common alert schema.
 */
public data class EmailReceiverArgs(
    public val emailAddress: Output<String>,
    public val name: Output<String>,
    public val useCommonAlertSchema: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.EmailReceiverArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.EmailReceiverArgs =
        com.pulumi.azurenative.insights.inputs.EmailReceiverArgs.builder()
            .emailAddress(emailAddress.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .useCommonAlertSchema(useCommonAlertSchema?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EmailReceiverArgs].
 */
@PulumiTagMarker
public class EmailReceiverArgsBuilder internal constructor() {
    private var emailAddress: Output<String>? = null

    private var name: Output<String>? = null

    private var useCommonAlertSchema: Output<Boolean>? = null

    /**
     * @param value The email address of this receiver.
     */
    @JvmName("pdvqwohokkoybsjp")
    public suspend fun emailAddress(`value`: Output<String>) {
        this.emailAddress = value
    }

    /**
     * @param value The name of the email receiver. Names must be unique across all receivers within a tenant action group.
     */
    @JvmName("ufswbhebqdobrbej")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Indicates whether to use common alert schema.
     */
    @JvmName("epostnenxwbsmgte")
    public suspend fun useCommonAlertSchema(`value`: Output<Boolean>) {
        this.useCommonAlertSchema = value
    }

    /**
     * @param value The email address of this receiver.
     */
    @JvmName("puwccqieecppfyda")
    public suspend fun emailAddress(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emailAddress = mapped
    }

    /**
     * @param value The name of the email receiver. Names must be unique across all receivers within a tenant action group.
     */
    @JvmName("qantmmkrxlappmdt")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Indicates whether to use common alert schema.
     */
    @JvmName("gstneefbosomapxi")
    public suspend fun useCommonAlertSchema(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useCommonAlertSchema = mapped
    }

    internal fun build(): EmailReceiverArgs = EmailReceiverArgs(
        emailAddress = emailAddress ?: throw PulumiNullFieldException("emailAddress"),
        name = name ?: throw PulumiNullFieldException("name"),
        useCommonAlertSchema = useCommonAlertSchema,
    )
}
