@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.EtwProviderConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property events
 * @property id
 */
public data class EtwProviderConfigurationArgs(
    public val events: Output<List<EtwEventConfigurationArgs>>,
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.EtwProviderConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.EtwProviderConfigurationArgs =
        com.pulumi.azurenative.insights.inputs.EtwProviderConfigurationArgs.builder()
            .events(events.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EtwProviderConfigurationArgs].
 */
@PulumiTagMarker
public class EtwProviderConfigurationArgsBuilder internal constructor() {
    private var events: Output<List<EtwEventConfigurationArgs>>? = null

    private var id: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("ufejqawogjdmsejv")
    public suspend fun events(`value`: Output<List<EtwEventConfigurationArgs>>) {
        this.events = value
    }

    @JvmName("iwmexytwluouuajy")
    public suspend fun events(vararg values: Output<EtwEventConfigurationArgs>) {
        this.events = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("lexpmmvtlwsysjaj")
    public suspend fun events(values: List<Output<EtwEventConfigurationArgs>>) {
        this.events = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("grnllsfxvpjlkakm")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value
     */
    @JvmName("cwydojvcemfuqnqp")
    public suspend fun events(`value`: List<EtwEventConfigurationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ndgcboorghneadxl")
    public suspend fun events(argument: List<suspend EtwEventConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EtwEventConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.events = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yhwpdpxtedyviipl")
    public suspend fun events(vararg argument: suspend EtwEventConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EtwEventConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.events = mapped
    }

    /**
     * @param argument
     */
    @JvmName("sqvlepaqniqwpqau")
    public suspend fun events(argument: suspend EtwEventConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EtwEventConfigurationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.events = mapped
    }

    /**
     * @param values
     */
    @JvmName("mdmtmypyiurrqehb")
    public suspend fun events(vararg values: EtwEventConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param value
     */
    @JvmName("yidrmhfkftwikhni")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): EtwProviderConfigurationArgs = EtwProviderConfigurationArgs(
        events = events ?: throw PulumiNullFieldException("events"),
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
