@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.ExtensionDataSourceArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.KnownExtensionDataSourceStreams
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Definition of which data will be collected from a separate VM extension that integrates with the Azure Monitor Agent.
 * Collected from either Windows and Linux machines, depending on which extension is defined.
 * @property extensionName The name of the VM extension.
 * @property extensionSettings The extension settings. The format is specific for particular extension.
 * @property inputDataSources The list of data sources this extension needs data from.
 * @property name A friendly name for the data source.
 * This name should be unique across all data sources (regardless of type) within the data collection rule.
 * @property streams List of streams that this data source will be sent to.
 * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
 */
public data class ExtensionDataSourceArgs(
    public val extensionName: Output<String>,
    public val extensionSettings: Output<Any>? = null,
    public val inputDataSources: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val streams: Output<List<Either<String, KnownExtensionDataSourceStreams>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.ExtensionDataSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.ExtensionDataSourceArgs =
        com.pulumi.azurenative.insights.inputs.ExtensionDataSourceArgs.builder()
            .extensionName(extensionName.applyValue({ args0 -> args0 }))
            .extensionSettings(extensionSettings?.applyValue({ args0 -> args0 }))
            .inputDataSources(inputDataSources?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .streams(
                streams?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            ).build()
}

/**
 * Builder for [ExtensionDataSourceArgs].
 */
@PulumiTagMarker
public class ExtensionDataSourceArgsBuilder internal constructor() {
    private var extensionName: Output<String>? = null

    private var extensionSettings: Output<Any>? = null

    private var inputDataSources: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var streams: Output<List<Either<String, KnownExtensionDataSourceStreams>>>? = null

    /**
     * @param value The name of the VM extension.
     */
    @JvmName("qiafcvqiiiuukuue")
    public suspend fun extensionName(`value`: Output<String>) {
        this.extensionName = value
    }

    /**
     * @param value The extension settings. The format is specific for particular extension.
     */
    @JvmName("pvdlfkxenresojik")
    public suspend fun extensionSettings(`value`: Output<Any>) {
        this.extensionSettings = value
    }

    /**
     * @param value The list of data sources this extension needs data from.
     */
    @JvmName("ksfuwbvjjuiomspm")
    public suspend fun inputDataSources(`value`: Output<List<String>>) {
        this.inputDataSources = value
    }

    @JvmName("patheflksrptcctn")
    public suspend fun inputDataSources(vararg values: Output<String>) {
        this.inputDataSources = Output.all(values.asList())
    }

    /**
     * @param values The list of data sources this extension needs data from.
     */
    @JvmName("okghehsyswildtmo")
    public suspend fun inputDataSources(values: List<Output<String>>) {
        this.inputDataSources = Output.all(values)
    }

    /**
     * @param value A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     */
    @JvmName("oylbwogwiilupiij")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
     */
    @JvmName("jegudcfdxqvmadbi")
    public suspend
    fun streams(`value`: Output<List<Either<String, KnownExtensionDataSourceStreams>>>) {
        this.streams = value
    }

    @JvmName("qqppjtnijjvilpki")
    public suspend fun streams(
        vararg
        values: Output<Either<String, KnownExtensionDataSourceStreams>>,
    ) {
        this.streams = Output.all(values.asList())
    }

    /**
     * @param values List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
     */
    @JvmName("imhsxcpbafqinkai")
    public suspend
    fun streams(values: List<Output<Either<String, KnownExtensionDataSourceStreams>>>) {
        this.streams = Output.all(values)
    }

    /**
     * @param value The name of the VM extension.
     */
    @JvmName("fddskuyhwvcjhqko")
    public suspend fun extensionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extensionName = mapped
    }

    /**
     * @param value The extension settings. The format is specific for particular extension.
     */
    @JvmName("txytxhprlarpwnye")
    public suspend fun extensionSettings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionSettings = mapped
    }

    /**
     * @param value The list of data sources this extension needs data from.
     */
    @JvmName("vrhohngweyliybcm")
    public suspend fun inputDataSources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputDataSources = mapped
    }

    /**
     * @param values The list of data sources this extension needs data from.
     */
    @JvmName("sybbdehcscidbqhc")
    public suspend fun inputDataSources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputDataSources = mapped
    }

    /**
     * @param value A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     */
    @JvmName("bkxgldltolxqjoig")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
     */
    @JvmName("ynuiiqblkyxhvwan")
    public suspend fun streams(`value`: List<Either<String, KnownExtensionDataSourceStreams>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streams = mapped
    }

    /**
     * @param values List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
     */
    @JvmName("viiuemcfvtmqfeid")
    public suspend fun streams(vararg values: Either<String, KnownExtensionDataSourceStreams>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streams = mapped
    }

    internal fun build(): ExtensionDataSourceArgs = ExtensionDataSourceArgs(
        extensionName = extensionName ?: throw PulumiNullFieldException("extensionName"),
        extensionSettings = extensionSettings,
        inputDataSources = inputDataSources,
        name = name,
        streams = streams,
    )
}
