@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetActivityLogAlertPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property activityLogAlertName The name of the Activity Log Alert rule.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetActivityLogAlertPlainArgs(
    public val activityLogAlertName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetActivityLogAlertPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.GetActivityLogAlertPlainArgs =
        com.pulumi.azurenative.insights.inputs.GetActivityLogAlertPlainArgs.builder()
            .activityLogAlertName(activityLogAlertName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetActivityLogAlertPlainArgs].
 */
@PulumiTagMarker
public class GetActivityLogAlertPlainArgsBuilder internal constructor() {
    private var activityLogAlertName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Activity Log Alert rule.
     */
    @JvmName("squbiaxpopfiphwy")
    public suspend fun activityLogAlertName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.activityLogAlertName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sumyyucqkxuifdvj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetActivityLogAlertPlainArgs = GetActivityLogAlertPlainArgs(
        activityLogAlertName = activityLogAlertName ?: throw
            PulumiNullFieldException("activityLogAlertName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
