@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetAnalyticsItemPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id The Id of a specific item defined in the Application Insights component
 * @property name The name of a specific item defined in the Application Insights component
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the Application Insights component resource.
 * @property scopePath Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component.
 */
public data class GetAnalyticsItemPlainArgs(
    public val id: String? = null,
    public val name: String? = null,
    public val resourceGroupName: String,
    public val resourceName: String,
    public val scopePath: String,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetAnalyticsItemPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.GetAnalyticsItemPlainArgs =
        com.pulumi.azurenative.insights.inputs.GetAnalyticsItemPlainArgs.builder()
            .id(id?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 }))
            .scopePath(scopePath.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAnalyticsItemPlainArgs].
 */
@PulumiTagMarker
public class GetAnalyticsItemPlainArgsBuilder internal constructor() {
    private var id: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    private var scopePath: String? = null

    /**
     * @param value The Id of a specific item defined in the Application Insights component
     */
    @JvmName("ohfuigakrrgtpsky")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value The name of a specific item defined in the Application Insights component
     */
    @JvmName("cwvbpelgmymqlvcs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bodthtbfwpvkmfqs")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Application Insights component resource.
     */
    @JvmName("udkpxlfnrsrvregc")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    /**
     * @param value Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component.
     */
    @JvmName("nbbqnpxldgxmiodi")
    public suspend fun scopePath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scopePath = mapped
    }

    internal fun build(): GetAnalyticsItemPlainArgs = GetAnalyticsItemPlainArgs(
        id = id,
        name = name,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        scopePath = scopePath ?: throw PulumiNullFieldException("scopePath"),
    )
}
