@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetDataCollectionRuleAssociationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property associationName The name of the association. The name is case insensitive.
 * @property resourceUri The identifier of the resource.
 */
public data class GetDataCollectionRuleAssociationPlainArgs(
    public val associationName: String,
    public val resourceUri: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetDataCollectionRuleAssociationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.insights.inputs.GetDataCollectionRuleAssociationPlainArgs =
        com.pulumi.azurenative.insights.inputs.GetDataCollectionRuleAssociationPlainArgs.builder()
            .associationName(associationName.let({ args0 -> args0 }))
            .resourceUri(resourceUri.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDataCollectionRuleAssociationPlainArgs].
 */
@PulumiTagMarker
public class GetDataCollectionRuleAssociationPlainArgsBuilder internal constructor() {
    private var associationName: String? = null

    private var resourceUri: String? = null

    /**
     * @param value The name of the association. The name is case insensitive.
     */
    @JvmName("nuvcfabsdgkkofpb")
    public suspend fun associationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.associationName = mapped
    }

    /**
     * @param value The identifier of the resource.
     */
    @JvmName("kkskwcedgrcjqait")
    public suspend fun resourceUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceUri = mapped
    }

    internal fun build(): GetDataCollectionRuleAssociationPlainArgs =
        GetDataCollectionRuleAssociationPlainArgs(
            associationName = associationName ?: throw PulumiNullFieldException("associationName"),
            resourceUri = resourceUri ?: throw PulumiNullFieldException("resourceUri"),
        )
}
