@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetLiveTokenPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceUri The identifier of the resource.
 */
public data class GetLiveTokenPlainArgs(
    public val resourceUri: String,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetLiveTokenPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.GetLiveTokenPlainArgs =
        com.pulumi.azurenative.insights.inputs.GetLiveTokenPlainArgs.builder()
            .resourceUri(resourceUri.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLiveTokenPlainArgs].
 */
@PulumiTagMarker
public class GetLiveTokenPlainArgsBuilder internal constructor() {
    private var resourceUri: String? = null

    /**
     * @param value The identifier of the resource.
     */
    @JvmName("qupjwjwvhqgbbslq")
    public suspend fun resourceUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceUri = mapped
    }

    internal fun build(): GetLiveTokenPlainArgs = GetLiveTokenPlainArgs(
        resourceUri = resourceUri ?: throw PulumiNullFieldException("resourceUri"),
    )
}
