@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetPrivateLinkScopePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scopeName The name of the Azure Monitor PrivateLinkScope resource.
 */
public data class GetPrivateLinkScopePlainArgs(
    public val resourceGroupName: String,
    public val scopeName: String,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetPrivateLinkScopePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.GetPrivateLinkScopePlainArgs =
        com.pulumi.azurenative.insights.inputs.GetPrivateLinkScopePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .scopeName(scopeName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateLinkScopePlainArgs].
 */
@PulumiTagMarker
public class GetPrivateLinkScopePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var scopeName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ohlkguccgauirfeh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Azure Monitor PrivateLinkScope resource.
     */
    @JvmName("yfbqpkvtlndluswy")
    public suspend fun scopeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scopeName = mapped
    }

    internal fun build(): GetPrivateLinkScopePlainArgs = GetPrivateLinkScopePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        scopeName = scopeName ?: throw PulumiNullFieldException("scopeName"),
    )
}
