@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetTestResultFilePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property continuationToken The continuation token.
 * @property downloadAs The format to use when returning the webtest result.
 * @property geoLocationId The location ID where the webtest was physically run.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property testSuccessfulCriteria The success state criteria for the webtest result.
 * @property timeStamp The posix (epoch) time stamp for the webtest result.
 * @property webTestName The name of the Application Insights webtest resource.
 */
public data class GetTestResultFilePlainArgs(
    public val continuationToken: String? = null,
    public val downloadAs: String,
    public val geoLocationId: String,
    public val resourceGroupName: String,
    public val testSuccessfulCriteria: Boolean? = null,
    public val timeStamp: Int,
    public val webTestName: String,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetTestResultFilePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.GetTestResultFilePlainArgs =
        com.pulumi.azurenative.insights.inputs.GetTestResultFilePlainArgs.builder()
            .continuationToken(continuationToken?.let({ args0 -> args0 }))
            .downloadAs(downloadAs.let({ args0 -> args0 }))
            .geoLocationId(geoLocationId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .testSuccessfulCriteria(testSuccessfulCriteria?.let({ args0 -> args0 }))
            .timeStamp(timeStamp.let({ args0 -> args0 }))
            .webTestName(webTestName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTestResultFilePlainArgs].
 */
@PulumiTagMarker
public class GetTestResultFilePlainArgsBuilder internal constructor() {
    private var continuationToken: String? = null

    private var downloadAs: String? = null

    private var geoLocationId: String? = null

    private var resourceGroupName: String? = null

    private var testSuccessfulCriteria: Boolean? = null

    private var timeStamp: Int? = null

    private var webTestName: String? = null

    /**
     * @param value The continuation token.
     */
    @JvmName("iwelrhevqygjgjmh")
    public suspend fun continuationToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.continuationToken = mapped
    }

    /**
     * @param value The format to use when returning the webtest result.
     */
    @JvmName("peuywnhyqxxlrxyj")
    public suspend fun downloadAs(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.downloadAs = mapped
    }

    /**
     * @param value The location ID where the webtest was physically run.
     */
    @JvmName("afetntfjudxysxwf")
    public suspend fun geoLocationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.geoLocationId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("otvpfajwjboyactf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The success state criteria for the webtest result.
     */
    @JvmName("jekneksfbkguotqf")
    public suspend fun testSuccessfulCriteria(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.testSuccessfulCriteria = mapped
    }

    /**
     * @param value The posix (epoch) time stamp for the webtest result.
     */
    @JvmName("picihjboensrpmar")
    public suspend fun timeStamp(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.timeStamp = mapped
    }

    /**
     * @param value The name of the Application Insights webtest resource.
     */
    @JvmName("kdjmnnmirkymfgtx")
    public suspend fun webTestName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.webTestName = mapped
    }

    internal fun build(): GetTestResultFilePlainArgs = GetTestResultFilePlainArgs(
        continuationToken = continuationToken,
        downloadAs = downloadAs ?: throw PulumiNullFieldException("downloadAs"),
        geoLocationId = geoLocationId ?: throw PulumiNullFieldException("geoLocationId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        testSuccessfulCriteria = testSuccessfulCriteria,
        timeStamp = timeStamp ?: throw PulumiNullFieldException("timeStamp"),
        webTestName = webTestName ?: throw PulumiNullFieldException("webTestName"),
    )
}
