@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.LogAnalyticsDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Log Analytics destination.
 * @property name A friendly name for the destination.
 * This name should be unique across all destinations (regardless of type) within the data collection rule.
 * @property workspaceResourceId The resource ID of the Log Analytics workspace.
 */
public data class LogAnalyticsDestinationArgs(
    public val name: Output<String>? = null,
    public val workspaceResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.LogAnalyticsDestinationArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.LogAnalyticsDestinationArgs =
        com.pulumi.azurenative.insights.inputs.LogAnalyticsDestinationArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .workspaceResourceId(workspaceResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogAnalyticsDestinationArgs].
 */
@PulumiTagMarker
public class LogAnalyticsDestinationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var workspaceResourceId: Output<String>? = null

    /**
     * @param value A friendly name for the destination.
     * This name should be unique across all destinations (regardless of type) within the data collection rule.
     */
    @JvmName("iagqxhgddfgsqvih")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource ID of the Log Analytics workspace.
     */
    @JvmName("moftfkhvtalltkuf")
    public suspend fun workspaceResourceId(`value`: Output<String>) {
        this.workspaceResourceId = value
    }

    /**
     * @param value A friendly name for the destination.
     * This name should be unique across all destinations (regardless of type) within the data collection rule.
     */
    @JvmName("tknlaitvooqkdriw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The resource ID of the Log Analytics workspace.
     */
    @JvmName("cnggriwdydlaxugv")
    public suspend fun workspaceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceResourceId = mapped
    }

    internal fun build(): LogAnalyticsDestinationArgs = LogAnalyticsDestinationArgs(
        name = name,
        workspaceResourceId = workspaceResourceId,
    )
}
