@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.LogicAppReceiverArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A logic app receiver.
 * @property callbackUrl The callback url where http request sent to.
 * @property name The name of the logic app receiver. Names must be unique across all receivers within an action group.
 * @property resourceId The azure resource id of the logic app receiver.
 * @property useCommonAlertSchema Indicates whether to use common alert schema.
 */
public data class LogicAppReceiverArgs(
    public val callbackUrl: Output<String>,
    public val name: Output<String>,
    public val resourceId: Output<String>,
    public val useCommonAlertSchema: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.LogicAppReceiverArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.LogicAppReceiverArgs =
        com.pulumi.azurenative.insights.inputs.LogicAppReceiverArgs.builder()
            .callbackUrl(callbackUrl.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .resourceId(resourceId.applyValue({ args0 -> args0 }))
            .useCommonAlertSchema(useCommonAlertSchema?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogicAppReceiverArgs].
 */
@PulumiTagMarker
public class LogicAppReceiverArgsBuilder internal constructor() {
    private var callbackUrl: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var useCommonAlertSchema: Output<Boolean>? = null

    /**
     * @param value The callback url where http request sent to.
     */
    @JvmName("pdvibusoffvgtakn")
    public suspend fun callbackUrl(`value`: Output<String>) {
        this.callbackUrl = value
    }

    /**
     * @param value The name of the logic app receiver. Names must be unique across all receivers within an action group.
     */
    @JvmName("sxfruyftyiwsbljf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The azure resource id of the logic app receiver.
     */
    @JvmName("jhiyuswnqnhqqhuq")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Indicates whether to use common alert schema.
     */
    @JvmName("xsuxenkshskscxlr")
    public suspend fun useCommonAlertSchema(`value`: Output<Boolean>) {
        this.useCommonAlertSchema = value
    }

    /**
     * @param value The callback url where http request sent to.
     */
    @JvmName("grxvcpknvsmdanyl")
    public suspend fun callbackUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.callbackUrl = mapped
    }

    /**
     * @param value The name of the logic app receiver. Names must be unique across all receivers within an action group.
     */
    @JvmName("gyyajhctrshowfod")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The azure resource id of the logic app receiver.
     */
    @JvmName("ndtpbsqrrdstrldg")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Indicates whether to use common alert schema.
     */
    @JvmName("lkjrrshjgdhcqlmw")
    public suspend fun useCommonAlertSchema(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useCommonAlertSchema = mapped
    }

    internal fun build(): LogicAppReceiverArgs = LogicAppReceiverArgs(
        callbackUrl = callbackUrl ?: throw PulumiNullFieldException("callbackUrl"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
        useCommonAlertSchema = useCommonAlertSchema,
    )
}
