@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.ManagementEventRuleConditionArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A management event rule condition.
 * @property aggregation How the data that is collected should be combined over time and when the alert is activated. Note that for management event alerts aggregation is optional – if it is not provided then any event will cause the alert to activate.
 * @property dataSource the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
 * @property odataType specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
 * Expected value is 'Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition'.
 */
public data class ManagementEventRuleConditionArgs(
    public val aggregation: Output<ManagementEventAggregationConditionArgs>? = null,
    public val dataSource:
    Output<Either<RuleManagementEventDataSourceArgs, RuleMetricDataSourceArgs>>? = null,
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.ManagementEventRuleConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.ManagementEventRuleConditionArgs =
        com.pulumi.azurenative.insights.inputs.ManagementEventRuleConditionArgs.builder()
            .aggregation(aggregation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dataSource(
                dataSource?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagementEventRuleConditionArgs].
 */
@PulumiTagMarker
public class ManagementEventRuleConditionArgsBuilder internal constructor() {
    private var aggregation: Output<ManagementEventAggregationConditionArgs>? = null

    private var dataSource:
        Output<Either<RuleManagementEventDataSourceArgs, RuleMetricDataSourceArgs>>? = null

    private var odataType: Output<String>? = null

    /**
     * @param value How the data that is collected should be combined over time and when the alert is activated. Note that for management event alerts aggregation is optional – if it is not provided then any event will cause the alert to activate.
     */
    @JvmName("ffldbhpwpcedbnsl")
    public suspend fun aggregation(`value`: Output<ManagementEventAggregationConditionArgs>) {
        this.aggregation = value
    }

    /**
     * @param value the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
     */
    @JvmName("alskoggakjdrdwnm")
    public suspend
    fun dataSource(`value`: Output<Either<RuleManagementEventDataSourceArgs, RuleMetricDataSourceArgs>>) {
        this.dataSource = value
    }

    /**
     * @param value specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
     * Expected value is 'Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition'.
     */
    @JvmName("uebmutixtlwfsarm")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value How the data that is collected should be combined over time and when the alert is activated. Note that for management event alerts aggregation is optional – if it is not provided then any event will cause the alert to activate.
     */
    @JvmName("klitvtlleejjddfe")
    public suspend fun aggregation(`value`: ManagementEventAggregationConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aggregation = mapped
    }

    /**
     * @param argument How the data that is collected should be combined over time and when the alert is activated. Note that for management event alerts aggregation is optional – if it is not provided then any event will cause the alert to activate.
     */
    @JvmName("ebotqeyqtdrohlqd")
    public suspend
    fun aggregation(argument: suspend ManagementEventAggregationConditionArgsBuilder.() -> Unit) {
        val toBeMapped = ManagementEventAggregationConditionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.aggregation = mapped
    }

    /**
     * @param value the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
     */
    @JvmName("vewfqjbfmxkjburx")
    public suspend
    fun dataSource(`value`: Either<RuleManagementEventDataSourceArgs, RuleMetricDataSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSource = mapped
    }

    /**
     * @param value the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
     */
    @JvmName("bitaepprmnfcigrr")
    public fun dataSource(`value`: RuleManagementEventDataSourceArgs) {
        val toBeMapped = Either.ofLeft<RuleManagementEventDataSourceArgs,
            RuleMetricDataSourceArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSource = mapped
    }

    /**
     * @param value the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
     */
    @JvmName("ebbybrsivyoogdfm")
    public fun dataSource(`value`: RuleMetricDataSourceArgs) {
        val toBeMapped = Either.ofRight<RuleManagementEventDataSourceArgs,
            RuleMetricDataSourceArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSource = mapped
    }

    /**
     * @param value specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
     * Expected value is 'Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition'.
     */
    @JvmName("cioxhaqhanigspcv")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): ManagementEventRuleConditionArgs = ManagementEventRuleConditionArgs(
        aggregation = aggregation,
        dataSource = dataSource,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
    )
}
