@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.PerfCounterDataSourceArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.KnownPerfCounterDataSourceStreams
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Definition of which performance counters will be collected and how they will be collected by this data collection rule.
 * Collected from both Windows and Linux machines where the counter is present.
 * @property counterSpecifiers A list of specifier names of the performance counters you want to collect.
 * Use a wildcard (*) to collect a counter for all instances.
 * To get a list of performance counters on Windows, run the command 'typeperf'.
 * @property name A friendly name for the data source.
 * This name should be unique across all data sources (regardless of type) within the data collection rule.
 * @property samplingFrequencyInSeconds The number of seconds between consecutive counter measurements (samples).
 * @property streams List of streams that this data source will be sent to.
 * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
 */
public data class PerfCounterDataSourceArgs(
    public val counterSpecifiers: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val samplingFrequencyInSeconds: Output<Int>? = null,
    public val streams: Output<List<Either<String, KnownPerfCounterDataSourceStreams>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.PerfCounterDataSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.PerfCounterDataSourceArgs =
        com.pulumi.azurenative.insights.inputs.PerfCounterDataSourceArgs.builder()
            .counterSpecifiers(counterSpecifiers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .samplingFrequencyInSeconds(samplingFrequencyInSeconds?.applyValue({ args0 -> args0 }))
            .streams(
                streams?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            ).build()
}

/**
 * Builder for [PerfCounterDataSourceArgs].
 */
@PulumiTagMarker
public class PerfCounterDataSourceArgsBuilder internal constructor() {
    private var counterSpecifiers: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var samplingFrequencyInSeconds: Output<Int>? = null

    private var streams: Output<List<Either<String, KnownPerfCounterDataSourceStreams>>>? = null

    /**
     * @param value A list of specifier names of the performance counters you want to collect.
     * Use a wildcard (*) to collect a counter for all instances.
     * To get a list of performance counters on Windows, run the command 'typeperf'.
     */
    @JvmName("bcoxucsbioffnvkf")
    public suspend fun counterSpecifiers(`value`: Output<List<String>>) {
        this.counterSpecifiers = value
    }

    @JvmName("ibtvkwhusoegieah")
    public suspend fun counterSpecifiers(vararg values: Output<String>) {
        this.counterSpecifiers = Output.all(values.asList())
    }

    /**
     * @param values A list of specifier names of the performance counters you want to collect.
     * Use a wildcard (*) to collect a counter for all instances.
     * To get a list of performance counters on Windows, run the command 'typeperf'.
     */
    @JvmName("huvlcknbqctmcces")
    public suspend fun counterSpecifiers(values: List<Output<String>>) {
        this.counterSpecifiers = Output.all(values)
    }

    /**
     * @param value A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     */
    @JvmName("piivhyrkpevpkrca")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The number of seconds between consecutive counter measurements (samples).
     */
    @JvmName("tucwyjuaahitfphl")
    public suspend fun samplingFrequencyInSeconds(`value`: Output<Int>) {
        this.samplingFrequencyInSeconds = value
    }

    /**
     * @param value List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
     */
    @JvmName("tixlbnvfxqiwejdw")
    public suspend
    fun streams(`value`: Output<List<Either<String, KnownPerfCounterDataSourceStreams>>>) {
        this.streams = value
    }

    @JvmName("rjbtlmkabquvupdx")
    public suspend fun streams(
        vararg
        values: Output<Either<String, KnownPerfCounterDataSourceStreams>>,
    ) {
        this.streams = Output.all(values.asList())
    }

    /**
     * @param values List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
     */
    @JvmName("cobtmlqgvageuacg")
    public suspend
    fun streams(values: List<Output<Either<String, KnownPerfCounterDataSourceStreams>>>) {
        this.streams = Output.all(values)
    }

    /**
     * @param value A list of specifier names of the performance counters you want to collect.
     * Use a wildcard (*) to collect a counter for all instances.
     * To get a list of performance counters on Windows, run the command 'typeperf'.
     */
    @JvmName("berdhcvlfngyvour")
    public suspend fun counterSpecifiers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.counterSpecifiers = mapped
    }

    /**
     * @param values A list of specifier names of the performance counters you want to collect.
     * Use a wildcard (*) to collect a counter for all instances.
     * To get a list of performance counters on Windows, run the command 'typeperf'.
     */
    @JvmName("kgwbdxegwoykedot")
    public suspend fun counterSpecifiers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.counterSpecifiers = mapped
    }

    /**
     * @param value A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     */
    @JvmName("rjwscahstpkgcwhq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The number of seconds between consecutive counter measurements (samples).
     */
    @JvmName("qxehvysdushxltkc")
    public suspend fun samplingFrequencyInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.samplingFrequencyInSeconds = mapped
    }

    /**
     * @param value List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
     */
    @JvmName("afrcelolfbwoxyqd")
    public suspend fun streams(`value`: List<Either<String, KnownPerfCounterDataSourceStreams>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streams = mapped
    }

    /**
     * @param values List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
     */
    @JvmName("mrtltytopavvqpgb")
    public suspend fun streams(vararg values: Either<String, KnownPerfCounterDataSourceStreams>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streams = mapped
    }

    internal fun build(): PerfCounterDataSourceArgs = PerfCounterDataSourceArgs(
        counterSpecifiers = counterSpecifiers,
        name = name,
        samplingFrequencyInSeconds = samplingFrequencyInSeconds,
        streams = streams,
    )
}
