@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.PlatformTelemetryDataSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Definition of platform telemetry data source configuration
 * @property name A friendly name for the data source.
 * This name should be unique across all data sources (regardless of type) within the data collection rule.
 * @property streams List of platform telemetry streams to collect
 */
public data class PlatformTelemetryDataSourceArgs(
    public val name: Output<String>? = null,
    public val streams: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.PlatformTelemetryDataSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.PlatformTelemetryDataSourceArgs =
        com.pulumi.azurenative.insights.inputs.PlatformTelemetryDataSourceArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .streams(streams.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PlatformTelemetryDataSourceArgs].
 */
@PulumiTagMarker
public class PlatformTelemetryDataSourceArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var streams: Output<List<String>>? = null

    /**
     * @param value A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     */
    @JvmName("wvmeaswkuxagxjao")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of platform telemetry streams to collect
     */
    @JvmName("fdhtbqqxqeqxqlmv")
    public suspend fun streams(`value`: Output<List<String>>) {
        this.streams = value
    }

    @JvmName("yfdiiaexlufuowcj")
    public suspend fun streams(vararg values: Output<String>) {
        this.streams = Output.all(values.asList())
    }

    /**
     * @param values List of platform telemetry streams to collect
     */
    @JvmName("gkcfvcxnasjtyuet")
    public suspend fun streams(values: List<Output<String>>) {
        this.streams = Output.all(values)
    }

    /**
     * @param value A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     */
    @JvmName("agblnygmkuxxecud")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of platform telemetry streams to collect
     */
    @JvmName("myucgtxatwdhmlsi")
    public suspend fun streams(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streams = mapped
    }

    /**
     * @param values List of platform telemetry streams to collect
     */
    @JvmName("xprppephtnwolbro")
    public suspend fun streams(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streams = mapped
    }

    internal fun build(): PlatformTelemetryDataSourceArgs = PlatformTelemetryDataSourceArgs(
        name = name,
        streams = streams ?: throw PulumiNullFieldException("streams"),
    )
}
