@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.RuleResolveConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * TBD. Relevant only for rules of the kind LogAlert.
 * @property autoResolved The flag that indicates whether or not to auto resolve a fired alert.
 * @property timeToResolve The duration a rule must evaluate as healthy before the fired alert is automatically resolved represented in ISO 8601 duration format.
 */
public data class RuleResolveConfigurationArgs(
    public val autoResolved: Output<Boolean>? = null,
    public val timeToResolve: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.RuleResolveConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.RuleResolveConfigurationArgs =
        com.pulumi.azurenative.insights.inputs.RuleResolveConfigurationArgs.builder()
            .autoResolved(autoResolved?.applyValue({ args0 -> args0 }))
            .timeToResolve(timeToResolve?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleResolveConfigurationArgs].
 */
@PulumiTagMarker
public class RuleResolveConfigurationArgsBuilder internal constructor() {
    private var autoResolved: Output<Boolean>? = null

    private var timeToResolve: Output<String>? = null

    /**
     * @param value The flag that indicates whether or not to auto resolve a fired alert.
     */
    @JvmName("eoptbeidohyookrf")
    public suspend fun autoResolved(`value`: Output<Boolean>) {
        this.autoResolved = value
    }

    /**
     * @param value The duration a rule must evaluate as healthy before the fired alert is automatically resolved represented in ISO 8601 duration format.
     */
    @JvmName("digrdbixniniaquu")
    public suspend fun timeToResolve(`value`: Output<String>) {
        this.timeToResolve = value
    }

    /**
     * @param value The flag that indicates whether or not to auto resolve a fired alert.
     */
    @JvmName("lkynawjwjjhsnbri")
    public suspend fun autoResolved(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoResolved = mapped
    }

    /**
     * @param value The duration a rule must evaluate as healthy before the fired alert is automatically resolved represented in ISO 8601 duration format.
     */
    @JvmName("kogxqxqiskskncwu")
    public suspend fun timeToResolve(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeToResolve = mapped
    }

    internal fun build(): RuleResolveConfigurationArgs = RuleResolveConfigurationArgs(
        autoResolved = autoResolved,
        timeToResolve = timeToResolve,
    )
}
