@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.RuleWebhookActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Specifies the action to post to service when the rule condition is evaluated. The discriminator is always RuleWebhookAction in this case.
 * @property odataType specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
 * Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleWebhookAction'.
 * @property properties the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
 * @property serviceUri the service uri to Post the notification when the alert activates or resolves.
 */
public data class RuleWebhookActionArgs(
    public val odataType: Output<String>,
    public val properties: Output<Map<String, String>>? = null,
    public val serviceUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.RuleWebhookActionArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.RuleWebhookActionArgs =
        com.pulumi.azurenative.insights.inputs.RuleWebhookActionArgs.builder()
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .serviceUri(serviceUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleWebhookActionArgs].
 */
@PulumiTagMarker
public class RuleWebhookActionArgsBuilder internal constructor() {
    private var odataType: Output<String>? = null

    private var properties: Output<Map<String, String>>? = null

    private var serviceUri: Output<String>? = null

    /**
     * @param value specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
     * Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleWebhookAction'.
     */
    @JvmName("cjtqfcdbtbmkohvk")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
     */
    @JvmName("bbnljuxuogtncyjr")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value the service uri to Post the notification when the alert activates or resolves.
     */
    @JvmName("exfygmyjddfhbyta")
    public suspend fun serviceUri(`value`: Output<String>) {
        this.serviceUri = value
    }

    /**
     * @param value specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
     * Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleWebhookAction'.
     */
    @JvmName("aywiulcqooidigfk")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
     */
    @JvmName("dfefucbfhusxyrad")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
     */
    @JvmName("lqbdbcvwfpyrjvjy")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value the service uri to Post the notification when the alert activates or resolves.
     */
    @JvmName("eqhertdkqrhaqlso")
    public suspend fun serviceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceUri = mapped
    }

    internal fun build(): RuleWebhookActionArgs = RuleWebhookActionArgs(
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        properties = properties,
        serviceUri = serviceUri,
    )
}
