@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.ScaleActionArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.ScaleDirection
import com.pulumi.azurenative.insights.kotlin.enums.ScaleType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The parameters for the scaling action.
 * @property cooldown the amount of time to wait since the last scaling action before this action occurs. It must be between 1 week and 1 minute in ISO 8601 format.
 * @property direction the scale direction. Whether the scaling action increases or decreases the number of instances.
 * @property type the type of action that should occur when the scale rule fires.
 * @property value the number of instances that are involved in the scaling action. This value must be 1 or greater. The default value is 1.
 */
public data class ScaleActionArgs(
    public val cooldown: Output<String>,
    public val direction: Output<ScaleDirection>,
    public val type: Output<ScaleType>,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.ScaleActionArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.ScaleActionArgs =
        com.pulumi.azurenative.insights.inputs.ScaleActionArgs.builder()
            .cooldown(cooldown.applyValue({ args0 -> args0 }))
            .direction(direction.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScaleActionArgs].
 */
@PulumiTagMarker
public class ScaleActionArgsBuilder internal constructor() {
    private var cooldown: Output<String>? = null

    private var direction: Output<ScaleDirection>? = null

    private var type: Output<ScaleType>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value the amount of time to wait since the last scaling action before this action occurs. It must be between 1 week and 1 minute in ISO 8601 format.
     */
    @JvmName("xpvosqeqcrsekaxd")
    public suspend fun cooldown(`value`: Output<String>) {
        this.cooldown = value
    }

    /**
     * @param value the scale direction. Whether the scaling action increases or decreases the number of instances.
     */
    @JvmName("wqqrmubtrtcxxwkh")
    public suspend fun direction(`value`: Output<ScaleDirection>) {
        this.direction = value
    }

    /**
     * @param value the type of action that should occur when the scale rule fires.
     */
    @JvmName("xtoudluaysciujqp")
    public suspend fun type(`value`: Output<ScaleType>) {
        this.type = value
    }

    /**
     * @param value the number of instances that are involved in the scaling action. This value must be 1 or greater. The default value is 1.
     */
    @JvmName("xideisernshljlrb")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value the amount of time to wait since the last scaling action before this action occurs. It must be between 1 week and 1 minute in ISO 8601 format.
     */
    @JvmName("oetlppqvywvbwbtr")
    public suspend fun cooldown(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cooldown = mapped
    }

    /**
     * @param value the scale direction. Whether the scaling action increases or decreases the number of instances.
     */
    @JvmName("kcmlgcfeytknhgew")
    public suspend fun direction(`value`: ScaleDirection) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value the type of action that should occur when the scale rule fires.
     */
    @JvmName("haiyqeqbowatfect")
    public suspend fun type(`value`: ScaleType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value the number of instances that are involved in the scaling action. This value must be 1 or greater. The default value is 1.
     */
    @JvmName("dhfspixvywbrrqts")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ScaleActionArgs = ScaleActionArgs(
        cooldown = cooldown ?: throw PulumiNullFieldException("cooldown"),
        direction = direction ?: throw PulumiNullFieldException("direction"),
        type = type ?: throw PulumiNullFieldException("type"),
        `value` = `value`,
    )
}
