@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.ScaleCapacityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The number of instances that can be used during this profile.
 * @property default the number of instances that will be set if metrics are not available for evaluation. The default is only used if the current instance count is lower than the default.
 * @property maximum the maximum number of instances for the resource. The actual maximum number of instances is limited by the cores that are available in the subscription.
 * @property minimum the minimum number of instances for the resource.
 */
public data class ScaleCapacityArgs(
    public val default: Output<String>,
    public val maximum: Output<String>,
    public val minimum: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.ScaleCapacityArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.ScaleCapacityArgs =
        com.pulumi.azurenative.insights.inputs.ScaleCapacityArgs.builder()
            .default_(default.applyValue({ args0 -> args0 }))
            .maximum(maximum.applyValue({ args0 -> args0 }))
            .minimum(minimum.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScaleCapacityArgs].
 */
@PulumiTagMarker
public class ScaleCapacityArgsBuilder internal constructor() {
    private var default: Output<String>? = null

    private var maximum: Output<String>? = null

    private var minimum: Output<String>? = null

    /**
     * @param value the number of instances that will be set if metrics are not available for evaluation. The default is only used if the current instance count is lower than the default.
     */
    @JvmName("qehjvrwworoateyk")
    public suspend fun default(`value`: Output<String>) {
        this.default = value
    }

    /**
     * @param value the maximum number of instances for the resource. The actual maximum number of instances is limited by the cores that are available in the subscription.
     */
    @JvmName("nliehwhicipsakoy")
    public suspend fun maximum(`value`: Output<String>) {
        this.maximum = value
    }

    /**
     * @param value the minimum number of instances for the resource.
     */
    @JvmName("oekuuedlptlgiecm")
    public suspend fun minimum(`value`: Output<String>) {
        this.minimum = value
    }

    /**
     * @param value the number of instances that will be set if metrics are not available for evaluation. The default is only used if the current instance count is lower than the default.
     */
    @JvmName("vfbuukdaicqsftaf")
    public suspend fun default(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.default = mapped
    }

    /**
     * @param value the maximum number of instances for the resource. The actual maximum number of instances is limited by the cores that are available in the subscription.
     */
    @JvmName("ucintyytuantyiaq")
    public suspend fun maximum(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maximum = mapped
    }

    /**
     * @param value the minimum number of instances for the resource.
     */
    @JvmName("cjubhrvubkbitkfb")
    public suspend fun minimum(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimum = mapped
    }

    internal fun build(): ScaleCapacityArgs = ScaleCapacityArgs(
        default = default ?: throw PulumiNullFieldException("default"),
        maximum = maximum ?: throw PulumiNullFieldException("maximum"),
        minimum = minimum ?: throw PulumiNullFieldException("minimum"),
    )
}
