@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.SinkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kind
 */
public data class SinkConfigurationArgs(
    public val kind: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.SinkConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.SinkConfigurationArgs =
        com.pulumi.azurenative.insights.inputs.SinkConfigurationArgs.builder()
            .kind(kind.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SinkConfigurationArgs].
 */
@PulumiTagMarker
public class SinkConfigurationArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("lnoypkdnfdqfqrsi")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value
     */
    @JvmName("dukrelxyhmwixevq")
    public suspend fun kind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    internal fun build(): SinkConfigurationArgs = SinkConfigurationArgs(
        kind = kind ?: throw PulumiNullFieldException("kind"),
    )
}
