@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.StorageBlobDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property containerName The container name of the Storage Blob.
 * @property name A friendly name for the destination.
 * This name should be unique across all destinations (regardless of type) within the data collection rule.
 * @property storageAccountResourceId The resource ID of the storage account.
 */
public data class StorageBlobDestinationArgs(
    public val containerName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val storageAccountResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.StorageBlobDestinationArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.StorageBlobDestinationArgs =
        com.pulumi.azurenative.insights.inputs.StorageBlobDestinationArgs.builder()
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .storageAccountResourceId(storageAccountResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageBlobDestinationArgs].
 */
@PulumiTagMarker
public class StorageBlobDestinationArgsBuilder internal constructor() {
    private var containerName: Output<String>? = null

    private var name: Output<String>? = null

    private var storageAccountResourceId: Output<String>? = null

    /**
     * @param value The container name of the Storage Blob.
     */
    @JvmName("xvhkgfkcfdmvjjjk")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value A friendly name for the destination.
     * This name should be unique across all destinations (regardless of type) within the data collection rule.
     */
    @JvmName("jrjjwbvpypwoyvck")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource ID of the storage account.
     */
    @JvmName("mtuklotipuqkmbpl")
    public suspend fun storageAccountResourceId(`value`: Output<String>) {
        this.storageAccountResourceId = value
    }

    /**
     * @param value The container name of the Storage Blob.
     */
    @JvmName("jisrvclsxytkxsve")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value A friendly name for the destination.
     * This name should be unique across all destinations (regardless of type) within the data collection rule.
     */
    @JvmName("rkxretocwdimitbl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The resource ID of the storage account.
     */
    @JvmName("cpvrehcqsimusaep")
    public suspend fun storageAccountResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountResourceId = mapped
    }

    internal fun build(): StorageBlobDestinationArgs = StorageBlobDestinationArgs(
        containerName = containerName,
        name = name,
        storageAccountResourceId = storageAccountResourceId,
    )
}
