@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.SyslogDataSourceArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.KnownSyslogDataSourceFacilityNames
import com.pulumi.azurenative.insights.kotlin.enums.KnownSyslogDataSourceLogLevels
import com.pulumi.azurenative.insights.kotlin.enums.KnownSyslogDataSourceStreams
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Definition of which syslog data will be collected and how it will be collected.
 * Only collected from Linux machines.
 * @property facilityNames The list of facility names.
 * @property logLevels The log levels to collect.
 * @property name A friendly name for the data source.
 * This name should be unique across all data sources (regardless of type) within the data collection rule.
 * @property streams List of streams that this data source will be sent to.
 * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
 */
public data class SyslogDataSourceArgs(
    public val facilityNames: Output<List<Either<String, KnownSyslogDataSourceFacilityNames>>>? =
        null,
    public val logLevels: Output<List<Either<String, KnownSyslogDataSourceLogLevels>>>? = null,
    public val name: Output<String>? = null,
    public val streams: Output<List<Either<String, KnownSyslogDataSourceStreams>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.SyslogDataSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.SyslogDataSourceArgs =
        com.pulumi.azurenative.insights.inputs.SyslogDataSourceArgs.builder()
            .facilityNames(
                facilityNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .logLevels(
                logLevels?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .streams(
                streams?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            ).build()
}

/**
 * Builder for [SyslogDataSourceArgs].
 */
@PulumiTagMarker
public class SyslogDataSourceArgsBuilder internal constructor() {
    private var facilityNames: Output<List<Either<String, KnownSyslogDataSourceFacilityNames>>>? =
        null

    private var logLevels: Output<List<Either<String, KnownSyslogDataSourceLogLevels>>>? = null

    private var name: Output<String>? = null

    private var streams: Output<List<Either<String, KnownSyslogDataSourceStreams>>>? = null

    /**
     * @param value The list of facility names.
     */
    @JvmName("uidxjjbgppcdqfbn")
    public suspend
    fun facilityNames(`value`: Output<List<Either<String, KnownSyslogDataSourceFacilityNames>>>) {
        this.facilityNames = value
    }

    @JvmName("qwlekwcjryfvovqj")
    public suspend fun facilityNames(
        vararg
        values: Output<Either<String, KnownSyslogDataSourceFacilityNames>>,
    ) {
        this.facilityNames = Output.all(values.asList())
    }

    /**
     * @param values The list of facility names.
     */
    @JvmName("qqcsshkebyliuugv")
    public suspend
    fun facilityNames(values: List<Output<Either<String, KnownSyslogDataSourceFacilityNames>>>) {
        this.facilityNames = Output.all(values)
    }

    /**
     * @param value The log levels to collect.
     */
    @JvmName("ycikihfgpuqhntqf")
    public suspend
    fun logLevels(`value`: Output<List<Either<String, KnownSyslogDataSourceLogLevels>>>) {
        this.logLevels = value
    }

    @JvmName("rxacncimoxnknjjq")
    public suspend fun logLevels(
        vararg
        values: Output<Either<String, KnownSyslogDataSourceLogLevels>>,
    ) {
        this.logLevels = Output.all(values.asList())
    }

    /**
     * @param values The log levels to collect.
     */
    @JvmName("hcutqvmmtsawxban")
    public suspend
    fun logLevels(values: List<Output<Either<String, KnownSyslogDataSourceLogLevels>>>) {
        this.logLevels = Output.all(values)
    }

    /**
     * @param value A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     */
    @JvmName("sywreguyiyivvbjb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
     */
    @JvmName("frnrnrgsswnstyou")
    public suspend fun streams(`value`: Output<List<Either<String, KnownSyslogDataSourceStreams>>>) {
        this.streams = value
    }

    @JvmName("myiecfpwaoqwrqaj")
    public suspend fun streams(vararg values: Output<Either<String, KnownSyslogDataSourceStreams>>) {
        this.streams = Output.all(values.asList())
    }

    /**
     * @param values List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
     */
    @JvmName("txgyyuovkqfgsdvs")
    public suspend fun streams(values: List<Output<Either<String, KnownSyslogDataSourceStreams>>>) {
        this.streams = Output.all(values)
    }

    /**
     * @param value The list of facility names.
     */
    @JvmName("twhnyokgydrpeoqf")
    public suspend
    fun facilityNames(`value`: List<Either<String, KnownSyslogDataSourceFacilityNames>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.facilityNames = mapped
    }

    /**
     * @param values The list of facility names.
     */
    @JvmName("raofewapywbacxqo")
    public suspend fun facilityNames(
        vararg
        values: Either<String, KnownSyslogDataSourceFacilityNames>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.facilityNames = mapped
    }

    /**
     * @param value The log levels to collect.
     */
    @JvmName("oolvlpjcrfarpsnb")
    public suspend fun logLevels(`value`: List<Either<String, KnownSyslogDataSourceLogLevels>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logLevels = mapped
    }

    /**
     * @param values The log levels to collect.
     */
    @JvmName("rqvjwjqdelswupev")
    public suspend fun logLevels(vararg values: Either<String, KnownSyslogDataSourceLogLevels>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logLevels = mapped
    }

    /**
     * @param value A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     */
    @JvmName("crxahxqsnifembiw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
     */
    @JvmName("vghesamtoqrudfrd")
    public suspend fun streams(`value`: List<Either<String, KnownSyslogDataSourceStreams>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streams = mapped
    }

    /**
     * @param values List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
     */
    @JvmName("cwvrnptrbosduqra")
    public suspend fun streams(vararg values: Either<String, KnownSyslogDataSourceStreams>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streams = mapped
    }

    internal fun build(): SyslogDataSourceArgs = SyslogDataSourceArgs(
        facilityNames = facilityNames,
        logLevels = logLevels,
        name = name,
        streams = streams,
    )
}
