@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.WebTestPropertiesContentValidationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The collection of content validation properties
 * @property contentMatch Content to look for in the return of the WebTest.  Must not be null or empty.
 * @property ignoreCase When set, this value makes the ContentMatch validation case insensitive.
 * @property passIfTextFound When true, validation will pass if there is a match for the ContentMatch string.  If false, validation will fail if there is a match
 */
public data class WebTestPropertiesContentValidationArgs(
    public val contentMatch: Output<String>? = null,
    public val ignoreCase: Output<Boolean>? = null,
    public val passIfTextFound: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.WebTestPropertiesContentValidationArgs> {
    override fun toJava():
        com.pulumi.azurenative.insights.inputs.WebTestPropertiesContentValidationArgs =
        com.pulumi.azurenative.insights.inputs.WebTestPropertiesContentValidationArgs.builder()
            .contentMatch(contentMatch?.applyValue({ args0 -> args0 }))
            .ignoreCase(ignoreCase?.applyValue({ args0 -> args0 }))
            .passIfTextFound(passIfTextFound?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebTestPropertiesContentValidationArgs].
 */
@PulumiTagMarker
public class WebTestPropertiesContentValidationArgsBuilder internal constructor() {
    private var contentMatch: Output<String>? = null

    private var ignoreCase: Output<Boolean>? = null

    private var passIfTextFound: Output<Boolean>? = null

    /**
     * @param value Content to look for in the return of the WebTest.  Must not be null or empty.
     */
    @JvmName("vcceoiwkodrmjpvn")
    public suspend fun contentMatch(`value`: Output<String>) {
        this.contentMatch = value
    }

    /**
     * @param value When set, this value makes the ContentMatch validation case insensitive.
     */
    @JvmName("ejnxpcrtcepcjhsm")
    public suspend fun ignoreCase(`value`: Output<Boolean>) {
        this.ignoreCase = value
    }

    /**
     * @param value When true, validation will pass if there is a match for the ContentMatch string.  If false, validation will fail if there is a match
     */
    @JvmName("edhxoglaluekerhj")
    public suspend fun passIfTextFound(`value`: Output<Boolean>) {
        this.passIfTextFound = value
    }

    /**
     * @param value Content to look for in the return of the WebTest.  Must not be null or empty.
     */
    @JvmName("ckaunedbjaclefra")
    public suspend fun contentMatch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentMatch = mapped
    }

    /**
     * @param value When set, this value makes the ContentMatch validation case insensitive.
     */
    @JvmName("pveqshqwhcfjonju")
    public suspend fun ignoreCase(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreCase = mapped
    }

    /**
     * @param value When true, validation will pass if there is a match for the ContentMatch string.  If false, validation will fail if there is a match
     */
    @JvmName("ffhpaooqlnogeerk")
    public suspend fun passIfTextFound(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passIfTextFound = mapped
    }

    internal fun build(): WebTestPropertiesContentValidationArgs =
        WebTestPropertiesContentValidationArgs(
            contentMatch = contentMatch,
            ignoreCase = ignoreCase,
            passIfTextFound = passIfTextFound,
        )
}
