@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.WebhookNotificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Webhook notification of an autoscale event.
 * @property properties a property bag of settings. This value can be empty.
 * @property serviceUri the service address to receive the notification.
 */
public data class WebhookNotificationArgs(
    public val properties: Output<Map<String, String>>? = null,
    public val serviceUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.WebhookNotificationArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.WebhookNotificationArgs =
        com.pulumi.azurenative.insights.inputs.WebhookNotificationArgs.builder()
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .serviceUri(serviceUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebhookNotificationArgs].
 */
@PulumiTagMarker
public class WebhookNotificationArgsBuilder internal constructor() {
    private var properties: Output<Map<String, String>>? = null

    private var serviceUri: Output<String>? = null

    /**
     * @param value a property bag of settings. This value can be empty.
     */
    @JvmName("vdvoccxondxdubkx")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value the service address to receive the notification.
     */
    @JvmName("ghlcshquxwwdqlcw")
    public suspend fun serviceUri(`value`: Output<String>) {
        this.serviceUri = value
    }

    /**
     * @param value a property bag of settings. This value can be empty.
     */
    @JvmName("ufxapobkmviahusn")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values a property bag of settings. This value can be empty.
     */
    @JvmName("lhsaoququjrvmmfp")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value the service address to receive the notification.
     */
    @JvmName("xrxcipjoemjtpqgl")
    public suspend fun serviceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceUri = mapped
    }

    internal fun build(): WebhookNotificationArgs = WebhookNotificationArgs(
        properties = properties,
        serviceUri = serviceUri,
    )
}
