@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.WorkbookTemplateLocalizedGalleryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Localized template data and gallery information.
 * @property galleries Workbook galleries supported by the template.
 * @property templateData Valid JSON object containing workbook template payload.
 */
public data class WorkbookTemplateLocalizedGalleryArgs(
    public val galleries: Output<List<WorkbookTemplateGalleryArgs>>? = null,
    public val templateData: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.WorkbookTemplateLocalizedGalleryArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.WorkbookTemplateLocalizedGalleryArgs =
        com.pulumi.azurenative.insights.inputs.WorkbookTemplateLocalizedGalleryArgs.builder()
            .galleries(
                galleries?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .templateData(templateData?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkbookTemplateLocalizedGalleryArgs].
 */
@PulumiTagMarker
public class WorkbookTemplateLocalizedGalleryArgsBuilder internal constructor() {
    private var galleries: Output<List<WorkbookTemplateGalleryArgs>>? = null

    private var templateData: Output<Any>? = null

    /**
     * @param value Workbook galleries supported by the template.
     */
    @JvmName("rafupjhcbshvvfgi")
    public suspend fun galleries(`value`: Output<List<WorkbookTemplateGalleryArgs>>) {
        this.galleries = value
    }

    @JvmName("pybrtxippsmwfiho")
    public suspend fun galleries(vararg values: Output<WorkbookTemplateGalleryArgs>) {
        this.galleries = Output.all(values.asList())
    }

    /**
     * @param values Workbook galleries supported by the template.
     */
    @JvmName("eqibsxltpdibdysl")
    public suspend fun galleries(values: List<Output<WorkbookTemplateGalleryArgs>>) {
        this.galleries = Output.all(values)
    }

    /**
     * @param value Valid JSON object containing workbook template payload.
     */
    @JvmName("qexkypwbmalcpwsk")
    public suspend fun templateData(`value`: Output<Any>) {
        this.templateData = value
    }

    /**
     * @param value Workbook galleries supported by the template.
     */
    @JvmName("rksitwnqqoavfqip")
    public suspend fun galleries(`value`: List<WorkbookTemplateGalleryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.galleries = mapped
    }

    /**
     * @param argument Workbook galleries supported by the template.
     */
    @JvmName("itxsmgfqxcepaspq")
    public suspend
    fun galleries(argument: List<suspend WorkbookTemplateGalleryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WorkbookTemplateGalleryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.galleries = mapped
    }

    /**
     * @param argument Workbook galleries supported by the template.
     */
    @JvmName("mhlryqafpqirmigt")
    public suspend fun galleries(
        vararg
        argument: suspend WorkbookTemplateGalleryArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WorkbookTemplateGalleryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.galleries = mapped
    }

    /**
     * @param argument Workbook galleries supported by the template.
     */
    @JvmName("pgsuiispsowxycoy")
    public suspend fun galleries(argument: suspend WorkbookTemplateGalleryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WorkbookTemplateGalleryArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.galleries = mapped
    }

    /**
     * @param values Workbook galleries supported by the template.
     */
    @JvmName("cysvrftvhcptmfsa")
    public suspend fun galleries(vararg values: WorkbookTemplateGalleryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.galleries = mapped
    }

    /**
     * @param value Valid JSON object containing workbook template payload.
     */
    @JvmName("occarypbwtmarrbi")
    public suspend fun templateData(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateData = mapped
    }

    internal fun build(): WorkbookTemplateLocalizedGalleryArgs = WorkbookTemplateLocalizedGalleryArgs(
        galleries = galleries,
        templateData = templateData,
    )
}
