@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Actions to invoke when the alert fires.
 * @property actionGroups Action Group resource Ids to invoke when the alert fires.
 * @property actionProperties The properties of an action properties.
 * @property customProperties The properties of an alert payload.
 */
public data class ActionsResponse(
    public val actionGroups: List<String>? = null,
    public val actionProperties: Map<String, String>? = null,
    public val customProperties: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.ActionsResponse):
            ActionsResponse = ActionsResponse(
            actionGroups = javaType.actionGroups().map({ args0 -> args0 }),
            actionProperties = javaType.actionProperties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            customProperties = javaType.customProperties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
