@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Definition of generic ARM proxy resource.
 * @property dataCollectionEndpointId The resource ID of the data collection endpoint that is to be associated.
 * @property dataCollectionRuleId The resource ID of the data collection rule that is to be associated.
 * @property description Description of the association.
 * @property etag Resource entity tag (ETag).
 * @property id Fully qualified ID of the resource.
 * @property metadata Metadata about the resource
 * @property name The name of the resource.
 * @property provisioningState The resource provisioning state.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource.
 */
public data class GetDataCollectionRuleAssociationResult(
    public val dataCollectionEndpointId: String? = null,
    public val dataCollectionRuleId: String? = null,
    public val description: String? = null,
    public val etag: String,
    public val id: String,
    public val metadata: DataCollectionRuleAssociationResponseMetadata,
    public val name: String,
    public val provisioningState: String,
    public val systemData: DataCollectionRuleAssociationProxyOnlyResourceResponseSystemData,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetDataCollectionRuleAssociationResult):
            GetDataCollectionRuleAssociationResult = GetDataCollectionRuleAssociationResult(
            dataCollectionEndpointId = javaType.dataCollectionEndpointId().map({ args0 -> args0 }).orElse(null),
            dataCollectionRuleId = javaType.dataCollectionRuleId().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id(),
            metadata = javaType.metadata().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionRuleAssociationResponseMetadata.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionRuleAssociationProxyOnlyResourceResponseSystemData.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
