@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The log profile resource.
 * @property categories the categories of the logs. These categories are created as is convenient to the user. Some values are: 'Write', 'Delete', and/or 'Action.'
 * @property id Azure resource Id
 * @property location Resource location
 * @property locations List of regions for which Activity Log events should be stored or streamed. It is a comma separated list of valid ARM locations including the 'global' location.
 * @property name Azure resource name
 * @property retentionPolicy the retention policy for the events in the log.
 * @property serviceBusRuleId The service bus rule ID of the service bus namespace in which you would like to have Event Hubs created for streaming the Activity Log. The rule ID is of the format: '{service bus resource ID}/authorizationrules/{key name}'.
 * @property storageAccountId the resource id of the storage account to which you would like to send the Activity Log.
 * @property tags Resource tags
 * @property type Azure resource type
 */
public data class GetLogProfileResult(
    public val categories: List<String>,
    public val id: String,
    public val location: String,
    public val locations: List<String>,
    public val name: String,
    public val retentionPolicy: RetentionPolicyResponse,
    public val serviceBusRuleId: String? = null,
    public val storageAccountId: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.GetLogProfileResult):
            GetLogProfileResult = GetLogProfileResult(
            categories = javaType.categories().map({ args0 -> args0 }),
            id = javaType.id(),
            location = javaType.location(),
            locations = javaType.locations().map({ args0 -> args0 }),
            name = javaType.name(),
            retentionPolicy = javaType.retentionPolicy().let({ args0 ->
                com.pulumi.azurenative.insights.kotlin.outputs.RetentionPolicyResponse.Companion.toKotlin(args0)
            }),
            serviceBusRuleId = javaType.serviceBusRuleId().map({ args0 -> args0 }).orElse(null),
            storageAccountId = javaType.storageAccountId().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
