@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Subscription migrate date information properties
 * @property isGrandFatherableSubscription Is subscription in the grand fatherable subscription list.
 * @property optedInDate Time to start using new pricing model.
 */
public data class ListEASubscriptionListMigrationDatePostResult(
    public val isGrandFatherableSubscription: Boolean? = null,
    public val optedInDate: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.ListEASubscriptionListMigrationDatePostResult):
            ListEASubscriptionListMigrationDatePostResult =
            ListEASubscriptionListMigrationDatePostResult(
                isGrandFatherableSubscription = javaType.isGrandFatherableSubscription().map({ args0 ->
                    args0
                }).orElse(null),
                optedInDate = javaType.optedInDate().map({ args0 -> args0 }).orElse(null),
            )
    }
}
