@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * How the data that is collected should be combined over time.
 * @property operator the condition operator.
 * @property threshold The threshold value that activates the alert.
 * @property windowSize the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
 */
public data class ManagementEventAggregationConditionResponse(
    public val `operator`: String? = null,
    public val threshold: Double? = null,
    public val windowSize: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.ManagementEventAggregationConditionResponse):
            ManagementEventAggregationConditionResponse = ManagementEventAggregationConditionResponse(
            `operator` = javaType.`operator`().map({ args0 -> args0 }).orElse(null),
            threshold = javaType.threshold().map({ args0 -> args0 }).orElse(null),
            windowSize = javaType.windowSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
