@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Specifies the metric alert criteria for multiple resource that has multiple metric criteria.
 * @property allOf the list of multiple metric criteria for this 'all of' operation.
 * @property odataType specifies the type of the alert criteria.
 * Expected value is 'Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria'.
 */
public data class MetricAlertMultipleResourceMultipleMetricCriteriaResponse(
    public val allOf: List<Either<DynamicMetricCriteriaResponse, MetricCriteriaResponse>>? = null,
    public val odataType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.MetricAlertMultipleResourceMultipleMetricCriteriaResponse):
            MetricAlertMultipleResourceMultipleMetricCriteriaResponse =
            MetricAlertMultipleResourceMultipleMetricCriteriaResponse(
                allOf = javaType.allOf().map({ args0 ->
                    args0.transform(
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.insights.kotlin.outputs.DynamicMetricCriteriaResponse.Companion.toKotlin(args0)
                            })
                        },
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.insights.kotlin.outputs.MetricCriteriaResponse.Companion.toKotlin(args0)
                            })
                        },
                    )
                }),
                odataType = javaType.odataType(),
            )
    }
}
