@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Customer Managed Identity
 * @property type The identity type.
 * @property userAssignedIdentities Customer Managed Identity
 */
public data class MyWorkbookManagedIdentityResponse(
    public val type: String? = null,
    public val userAssignedIdentities: MyWorkbookUserAssignedIdentitiesResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.MyWorkbookManagedIdentityResponse):
            MyWorkbookManagedIdentityResponse = MyWorkbookManagedIdentityResponse(
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.MyWorkbookUserAssignedIdentitiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
