@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Definition of which performance counters will be collected and how they will be collected by this data collection rule.
 * Collected from both Windows and Linux machines where the counter is present.
 * @property counterSpecifiers A list of specifier names of the performance counters you want to collect.
 * Use a wildcard (*) to collect a counter for all instances.
 * To get a list of performance counters on Windows, run the command 'typeperf'.
 * @property name A friendly name for the data source.
 * This name should be unique across all data sources (regardless of type) within the data collection rule.
 * @property samplingFrequencyInSeconds The number of seconds between consecutive counter measurements (samples).
 * @property streams List of streams that this data source will be sent to.
 * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
 */
public data class PerfCounterDataSourceResponse(
    public val counterSpecifiers: List<String>? = null,
    public val name: String? = null,
    public val samplingFrequencyInSeconds: Int? = null,
    public val streams: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.PerfCounterDataSourceResponse):
            PerfCounterDataSourceResponse = PerfCounterDataSourceResponse(
            counterSpecifiers = javaType.counterSpecifiers().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            samplingFrequencyInSeconds = javaType.samplingFrequencyInSeconds().map({ args0 ->
                args0
            }).orElse(null),
            streams = javaType.streams().map({ args0 -> args0 }),
        )
    }
}
