@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A voice receiver.
 * @property countryCode The country code of the voice receiver.
 * @property name The name of the voice receiver. Names must be unique across all receivers within a tenant action group.
 * @property phoneNumber The phone number of the voice receiver.
 */
public data class VoiceReceiverResponse(
    public val countryCode: String,
    public val name: String,
    public val phoneNumber: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.VoiceReceiverResponse):
            VoiceReceiverResponse = VoiceReceiverResponse(
            countryCode = javaType.countryCode(),
            name = javaType.name(),
            phoneNumber = javaType.phoneNumber(),
        )
    }
}
